--------------------------------------------------------------------------------
--  Copyright(C) 2004 by Xilinx, Inc. All rights reserved.
--  This text/file contains proprietary, confidential
--  information of Xilinx, Inc., is distributed under license
--  from Xilinx, Inc., and may be used, copied and/or
--  disclosed only pursuant to the terms of a valid license
--  agreement with Xilinx, Inc.  Xilinx hereby grants you
--  a license to use this text/file solely for design, simulation,
--  implementation and creation of design files limited
--  to Xilinx devices or technologies. Use with non-Xilinx
--  devices or technologies is expressly prohibited and
--  immediately terminates your license unless covered by
--  a separate agreement.
--
--  Xilinx is providing this design, code, or information
--  "as is" solely for use in developing programs and
--  solutions for Xilinx devices.  By providing this design,
--  code, or information as one possible implementation of
--  this feature, application or standard, Xilinx is making no
--  representation that this implementation is free from any
--  claims of infringement.  You are responsible for
--  obtaining any rights you may require for your implementation.
--  Xilinx expressly disclaims any warranty whatsoever with
--  respect to the adequacy of the implementation, including
--  but not limited to any warranties or representations that this
--  implementation is free from claims of infringement, implied
--  warranties of merchantability or fitness for a particular
--  purpose.
--
--  Xilinx products are not intended for use in life support
--  appliances, devices, or systems. Use in such applications are
--  expressly prohibited.
--
--  This copyright and support notice must be retained as part
--  of this text at all times. (c) Copyright 1995-2004 Xilinx, Inc.
--  All rights reserved.
--------------------------------------------------------------------------------
-- $RCSfile: cordic_v3_0.vhd,v $
--------------------------------------------------------------------------------
-- Project  : cordic
-- Unit     : c_cordic_v3_0
-- Author   : Jeffrey Graham
-- Function :  Top Level CORDIC Behavioural Model 
--------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY cordic_v3_0 IS
  GENERIC (
    c_architecture	: INTEGER := 2; 
    c_cordic_function : INTEGER := 0;
    c_coarse_rotate : INTEGER := 1;
    c_data_format : INTEGER := 0;
    c_enable_rlocs : INTEGER := 1;
    c_family : STRING := "virtex2";
    c_has_aclr : INTEGER := 0;
    c_has_ce : INTEGER := 0;
    c_has_clk : INTEGER := 0;
    c_has_nd : INTEGER := 0;
    c_has_phase_in : INTEGER := 0;
    c_has_phase_out : INTEGER := 0;
    c_has_rdy : INTEGER := 0;
    c_has_rfd : INTEGER := 0;
    c_has_sclr : INTEGER := 0;
    c_has_x_in : INTEGER := 0;
    c_has_x_out : INTEGER := 0;
    c_has_y_in : INTEGER := 0;
    c_has_y_out : INTEGER := 0;
    c_input_width : INTEGER := 32;
    c_iterations : INTEGER := 16;
    c_mif_file_prefix : STRING := "cor1";
    c_output_width : INTEGER := 16;
    c_phase_format : INTEGER := 0;
    c_pipeline_mode : INTEGER := -2;
    c_precision : INTEGER := 0;
    c_reg_inputs : INTEGER := 1;
    c_reg_outputs : INTEGER := 1;
    c_round_mode : INTEGER := 2;
    c_scale_comp : INTEGER := 0;
    c_sync_enable : INTEGER := 0
    );
  PORT (
    x_in : IN STD_LOGIC_VECTOR(c_input_width-1 DOWNTO 0) := (OTHERS => '0');
    y_in : IN STD_LOGIC_VECTOR(c_input_width-1 DOWNTO 0) := (OTHERS => '0');
    phase_in : IN STD_LOGIC_VECTOR(c_input_width-1 DOWNTO 0) := (OTHERS => '0');
    nd : IN STD_LOGIC := '1';
    x_out : OUT STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0);
    y_out : OUT STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0);
    phase_out : OUT STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0);
    rdy : OUT STD_LOGIC;
    rfd : OUT STD_LOGIC;
    clk : IN STD_LOGIC := '1';
    ce : IN STD_LOGIC := '1';
    aclr : IN STD_LOGIC := '0';
    sclr : IN STD_LOGIC := '0'
  );  

END cordic_v3_0;


LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

--USE ieee.std_logic_signed.ALL;
--USE XilinxCoreLib.iputils_std_logic_signed.ALL;

LIBRARY XilinxCoreLib;
USE XilinxCoreLib.mult_gen_v7_0_services.ALL;

PACKAGE cordic_pack_beh IS

  FUNCTION CORDIC_BEH_funct_has_port(cordic_funct, position: INTEGER) RETURN INTEGER;
  
  FUNCTION CORDIC_BEH_get_transform_type(cordic_funct : INTEGER)RETURN INTEGER;
  
  FUNCTION CORDIC_BEH_get_eng_mode(cordic_funct: INTEGER) RETURN STD_LOGIC;
  
  FUNCTION CORDIC_BEH_get_iterations_int(coarse_rotate : INTEGER; cordic_funct : INTEGER; iterations : INTEGER; 
             output_width : INTEGER; round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_precision_int(cordic_funct : INTEGER; data_format : INTEGER;input_width : INTEGER;
             iterations_int : INTEGER; output_width : INTEGER; precision : INTEGER; round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_rnd_mode_int(cordic_funct : INTEGER; round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_scale_comp_int(family : STRING; scale_comp : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_select_slv_int (a: STD_LOGIC_VECTOR; b : STD_LOGIC_VECTOR; sel : INTEGER) RETURN STD_LOGIC_VECTOR;

  FUNCTION CORDIC_BEH_gen_ctrl_width(coarse_rotate : INTEGER) RETURN INTEGER;
  
  FUNCTION CORDIC_BEH_get_current_iteration(I : INTEGER;transform_type : INTEGER)RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_round_ext(round_mode : INTEGER) RETURN INTEGER;
  
  FUNCTION CORDIC_BEH_get_rnd_pipe_int(p_pipeline_mode:INTEGER; p_reg_outputs:INTEGER)RETURN INTEGER;
  
  FUNCTION CORDIC_BEH_get_mult_type_int(scale_comp : INTEGER) RETURN INTEGER;

--  FUNCTION CORDIC_BEH_get_mult_width_int(output_width : INTEGER; mult_type : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_log2_rnd_up(x : INTEGER) RETURN INTEGER;
  
  FUNCTION getLatency(architecture_sel : INTEGER; coarse_rotate : INTEGER; cordic_function : INTEGER;
             data_format : INTEGER; family : STRING; input_width : INTEGER; iterations : INTEGER; output_width : INTEGER;
             pipeline_mode : INTEGER; precision : INTEGER; reg_inputs : INTEGER; reg_outputs: INTEGER;
             round_mode : INTEGER; scale_comp : INTEGER)
             RETURN INTEGER;
                      
  FUNCTION CORDIC_BEH_get_inp_config_latency(architecture_sel : INTEGER; coarse_rotate : INTEGER; 
             cordic_function : INTEGER; pipeline_mode : INTEGER; reg_inputs : INTEGER)
             RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_engine_latency(architecture_sel : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER)
             RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_out_config_latency(architecture_sel : INTEGER; coarse_rotate : INTEGER; 
             cordic_function : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER; precision_int : INTEGER;
             reg_outputs : INTEGER; round_mode : INTEGER; scale_comp_int : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_scale_latency(cordic_function : INTEGER; precision_int : INTEGER; iterations_int : INTEGER;
                                 pipeline_mode: INTEGER; scale_comp_int: INTEGER)RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_round_latency(pipeline_mode : INTEGER; round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_sqrt_latency(data_format:INTEGER;input_width:INTEGER;output_width:INTEGER;
                      pipeline_mode:INTEGER;precision:INTEGER;reg_inputs:INTEGER; reg_outputs:INTEGER;
                      round_mode:INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_BEH_get_rfd_latency(architecture_sel : INTEGER;coarse_rotate : INTEGER;cordic_function : INTEGER;
                      iterations_int : INTEGER;pipeline_mode : INTEGER;reg_inputs : INTEGER) 
                      RETURN INTEGER;

  --Function to set all bits in a vector (ie Others Statement Replacement)
  FUNCTION CORDIC_BEH_set_vect_slv(a: STD_LOGIC_VECTOR; val: STD_LOGIC) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_init_vect_slv(len: INTEGER; val: STD_LOGIC) RETURN STD_LOGIC_VECTOR;

  --Convert from type Std_logic Vector
  FUNCTION CORDIC_BEH_slv_to_str(a: STD_LOGIC_VECTOR) RETURN STRING;
  FUNCTION CORDIC_BEH_str_to_slv(a: STRING) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_nat_to_slv(a: NATURAL; len: INTEGER) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_slv_to_nat(a: STD_LOGIC_VECTOR) RETURN NATURAL;
  FUNCTION CORDIC_BEH_int_to_slv(a: INTEGER; len: INTEGER) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_int_to_sl(a : INTEGER) RETURN STD_LOGIC;
  FUNCTION CORDIC_BEH_slv_to_int(a: STD_LOGIC_VECTOR) RETURN INTEGER;
  FUNCTION CORDIC_BEH_sl_to_int(a : STD_LOGIC) RETURN INTEGER;
  FUNCTION CORDIC_BEH_real_to_slv(a:REAL; len:INTEGER; fmt:INTEGER) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_slv_to_real(a:STD_LOGIC_VECTOR; fmt:INTEGER) RETURN REAL;
  FUNCTION CORDIC_BEH_sbv_to_slv(a:BIT_VECTOR) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_slv_to_sbv(a:STD_LOGIC_VECTOR) RETURN BIT_VECTOR;

  FUNCTION CORDIC_BEH_max_int(a : IN INTEGER; b : IN INTEGER) RETURN INTEGER;
  FUNCTION CORDIC_BEH_min_int(a : IN INTEGER; b : IN INTEGER) RETURN INTEGER;  

  -- Functions to Round
  FUNCTION CORDIC_BEH_rnd_slv(a : IN STD_LOGIC_VECTOR; mode : IN INTEGER; precision : IN INTEGER) RETURN STD_LOGIC_VECTOR;

  --Left/Right STD LOGIC VECTOR.
  FUNCTION CORDIC_BEH_rshift_slv(a : IN STD_LOGIC_VECTOR; shift : IN INTEGER) RETURN STD_LOGIC_VECTOR;  

  --Add/Sub Carry
  FUNCTION CORDIC_BEH_add_sub_signed_slv(a : STD_LOGIC_VECTOR; b : STD_LOGIC_VECTOR; add_nsub : STD_LOGIC;
                                          c : STD_LOGIC) RETURN STD_LOGIC_VECTOR;

  --Implement CORDIC scale function.
  FUNCTION CORDIC_BEH_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_inv_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STD_LOGIC_VECTOR;
  FUNCTION CORDIC_BEH_inv_cordic_scale_str(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STRING;

  ----------------------------------------------------------------------------
  --CONSTANTS used to configure CORDIC
  ----------------------------------------------------------------------------
  -- Used to set c_cordic_function
  CONSTANT CORDIC_BEH_f_rotate : INTEGER := 0; 
  CONSTANT CORDIC_BEH_f_translate : INTEGER := 1;
  CONSTANT CORDIC_BEH_f_sin_cos : INTEGER := 2;
  CONSTANT CORDIC_BEH_f_atan : INTEGER := 3;
  CONSTANT CORDIC_BEH_f_sinh_cosh : INTEGER := 4;
  CONSTANT CORDIC_BEH_f_atanh : INTEGER := 5;
  CONSTANT CORDIC_BEH_f_sqrt : INTEGER := 6;
  CONSTANT CORDIC_BEH_f_default : INTEGER := 7;

  -- Used to set c_architecture
  CONSTANT CORDIC_BEH_bser_arch : INTEGER := 0; -- Select Bit Serial Architecture (Not Implemented)
  CONSTANT CORDIC_BEH_wser_arch : INTEGER := 1; -- Select Word Serial Architecture
  CONSTANT CORDIC_BEH_para_arch : INTEGER := 2; -- Select Parallel Aarchitecture

  -- Used to set c_data_format
  CONSTANT CORDIC_BEH_format_sig_frac : INTEGER := 0;
  CONSTANT CORDIC_BEH_format_usig_frac : INTEGER := 1;
  CONSTANT CORDIC_BEH_format_usig_int : INTEGER := 2;

  -- Used to set c_phase_format
  CONSTANT CORDIC_BEH_format_rad : INTEGER := 0;
  CONSTANT CORDIC_BEH_format_sca : INTEGER := 1;

  -- Used to set c_data_width
  CONSTANT CORDIC_BEH_data_width_max : INTEGER := 64;   

  -- Used to set c_round_mode
  CONSTANT CORDIC_BEH_round_truncate : INTEGER := 0;
  CONSTANT CORDIC_BEH_round_pos_inf: INTEGER := 1;
  CONSTANT CORDIC_BEH_round_pos_neg_inf : INTEGER := 2;
  CONSTANT CORDIC_BEH_round_nearest_even : INTEGER := 3;

  -- Used to set c_scale_comp
  CONSTANT CORDIC_BEH_scale_none : INTEGER := 0;
  CONSTANT CORDIC_BEH_scale_ccm: INTEGER := 1;
  CONSTANT CORDIC_BEH_scale_block: INTEGER := 2;
  CONSTANT CORDIC_BEH_scale_dsp48: INTEGER := 3;

  -- Used to set c_pipeline_mode
  CONSTANT CORDIC_BEH_pipe_none : INTEGER := 0;
  CONSTANT CORDIC_BEH_pipe_opt: INTEGER := -1;
  CONSTANT CORDIC_BEH_pipe_max: INTEGER := -2;
  
  -- Used to Specify Layout Orientation
  CONSTANT CORDIC_BEH_layout_depth_width : INTEGER := 0; 
  CONSTANT CORDIC_BEH_layout_width_depth : INTEGER := 1;
  
  -- Used for I/O Port
  CONSTANT CORDIC_BEH_x_in_port : INTEGER := 5;
  CONSTANT CORDIC_BEH_y_in_port : INTEGER := 4;
  CONSTANT CORDIC_BEH_pha_in_port : INTEGER := 3;
  CONSTANT CORDIC_BEH_x_out_port : INTEGER := 2;
  CONSTANT CORDIC_BEH_y_out_port : INTEGER := 1;
  CONSTANT CORDIC_BEH_pha_out_port : INTEGER := 0;

  --Constants used to set the engine operational mode
  CONSTANT CORDIC_BEH_em_rotational : STD_LOGIC := '0';
  CONSTANT CORDIC_BEH_em_translation : STD_LOGIC := '1';
  
  CONSTANT CORDIC_BEH_trig_transform : INTEGER := 0;
  CONSTANT CORDIC_BEH_hyp_transform : INTEGER := 1;

  ----------------------------------------------------------------------------
  --Constants used to set DEFAULT VALUES  
  ----------------------------------------------------------------------------
  CONSTANT CORDIC_BEH_new_line : STRING(1 TO 1) := (1 => lf); -- For assertion reports

  CONSTANT CORDIC_BEH_cordic_io_cnt : INTEGER := 6;
  
  CONSTANT CORDIC_BEH_max_rom_width : INTEGER := 72;
  CONSTANT CORDIC_BEH_max_rom_length : INTEGER := 64;

  CONSTANT CORDIC_BEH_wser_slice_opt : INTEGER := 16;
  CONSTANT CORDIC_BEH_rom_block_depth : INTEGER := 16;
  CONSTANT CORDIC_BEH_rom_block_addr : INTEGER := 4;
    
  CONSTANT CORDIC_BEH_cordic_scale_trig_const_slv : 
    STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000001" &
   "010010101000011000011011110100111101000001000111100001000011100001110110" &
   "010010101000011000011011110100111101000001000111100001000011100001010010" &
   "010010101000011000011011110100111101000001000111100001000011011110111100" &
   "010010101000011000011011110100111101000001000111100001000011010101101001" &
   "010010101000011000011011110100111101000001000111100001000010110000011000" &
   "010010101000011000011011110100111101000001000111100001000000011011010100" &
   "010010101000011000011011110100111101000001000111100000110111000111001001" &
   "010010101000011000011011110100111101000001000111100000010001110110010111" &
   "010010101000011000011011110100111101000001000111011101111100110011010101" &
   "010010101000011000011011110100111101000001000111010100101000100111000111" &
   "010010101000011000011011110100111101000001000110101111010111110110001111" &
   "010010101000011000011011110100111101000001000100011010010100110010110001" &
   "010010101000011000011011110100111101000000111011000110001000100100110100" &
   "010010101000011000011011110100111101000000010101110101010111101101001011" &
   "010010101000011000011011110100111100111110000000110010010100001110100101" &
   "010010101000011000011011110100111100110100101100100110000110010100000101" &
   "010010101000011000011011110100111100001111011011110101001110101010001110" &
   "010010101000011000011011110100111001111010011000110001110000000011001000" &
   "010010101000011000011011110100110000100110001100100011110101101101001001" &
   "010010101000011000011011110100001011010101011011101100001101111011101111" &
   "010010101000011000011011110001110110010010011000001110001000011101101000" &
   "010010101000011000011011101000100010000110001010011100001100011101100110" &
   "010010101000011000011011000011010001010101010100111010111010100011110011" &
   "010010101000011000011000101110001110010010011000011101010100011011111010" &
   "010010101000011000001111011010000010001101000000011111001110101100011011" &
   "010010101000010111101010001001010011011101111110100110011100100000011001" &
   "010010101000010101010101000110110010001001010001110101010100100001000110" &
   "010010101000001100000001000011000110101000000100001001101001110001000101" &
   "010010100111100110110010011010101111110101101101110010101000000111001011" &
   "010010100101010010010001011010000011100100011010011101001100101001000111" &
   "010010011100000110100000100001100100000010111010011010001000011111111011" &
   "010001111000110111011110011011100101111111010010100111110000010101111101");

  CONSTANT CORDIC_BEH_cordic_scale_hyp_const_slv :
    STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011101" &
   "001101010000000010010000000111101100110011010011000111001100001100011110" &
   "001101010000000010010000000111101100110011010011000111001100001100100101" &
   "001101010000000010010000000111101100110011010011000111001100001100111111" &
   "001101010000000010010000000111101100110011010011000111001100001110101001" &
   "001101010000000010010000000111101100110011010011000111001100010101010001" &
   "001101010000000010010000000111101100110011010011000111001100101111110001" &
   "001101010000000010010000000111101100110011010011000111001110011001110010" &
   "001101010000000010010000000111101100110011010011000111010101000001110011" &
   "001101010000000010010000000111101100110011010011000111101111100001110111" &
   "001101010000000010010000000111101100110011010011001001011001100010001001" &
   "001101010000000010010000000111101100110011010011010000000001100011010001" &
   "001101010000000010010000000111101100110011010011101010100001100111110010" &
   "001101010000000010010000000111101100110011010101010100100001111001110011" &
   "001101010000000010010000000111101100110011011011111100100011000001110110" &
   "001101010000000010010000000111101100110011110110011100100111100010000110" &
   "001101010000000010010000000111101100110101100000011100111001100011000011" &
   "001101010000000010010000000111101100111100001000011110000001100110111010" &
   "001101010000000010010000000111101101010110101000100010100001110110010101" &
   "001101010000000010010000000111101111000000101000110100100010110100010100" &
   "001101010000000010010000000111110101101000101001111100100110110000110010" &
   "001101010000000010010000001000010000001000101110011100110111101011100100" &
   "001101010000000010010000001001111010001001000000011110001101100100101101" &
   "001101010000000010010000001011100100001001010010011111110000101101111000" &
   "001101010000000010010000010010001100001010011010101010100000110011011000" &
   "001101010000000010010000101100101100001110111100011110011001010101110011" &
   "001101010000000010010010010110101100100001010101111011111110101010100011" &
   "001101010000000010011000111110101101101111011111010011001010010111000010" &
   "001101010000000010110011011110110011110000111101000001001000001110111001" &
   "001101010000000100011101011111011110000100111011110101011111110110110000" &
   "001101010000001011000101100110101010111010011111000000110010001101101010" &
   "001101010000100101100111001100011011010011101000011100000010001010010110" &
   "001101010010001111111111110110010111010111110011011100110100010001011101" &
   "001101010011111010100101110101111000110001110100111001010000011110011110" &
   "001101011010101001100110110100101100011111011101111101110100010000011101" &
   "001101110110110011110101110100001011000010011001010101001110011101100100");
   
   CONSTANT CORDIC_BEH_inv_cordic_scale_trig_const_slv : 
     STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011011" &
   "001101101111011001010110110001011001110111110000010011011011101011100011" &
   "001101101111011001010110110001011001110111110000010011011011101011111110" &
   "001101101111011001010110110001011001110111110000010011011011101101101100" &
   "001101101111011001010110110001011001110111110000010011011011110100100011" &
   "001101101111011001010110110001011001110111110000010011011100010000000010" &
   "001101101111011001010110110001011001110111110000010011011101111101111110" &
   "001101101111011001010110110001011001110111110000010011100100110101101010" &
   "001101101111011001010110110001011001110111110000010100000000010100011101" &
   "001101101111011001010110110001011001110111110000010101101110001111100111" &
   "001101101111011001010110110001011001110111110000011100100101111100010011" &
   "001101101111011001010110110001011001110111110000111000000100101111000000" &
   "001101101111011001010110110001011001110111110010100101111111111001110110" &
   "001101101111011001010110110001011001110111111001011101101100100101010001" &
   "001101101111011001010110110001011001111000010100111100011111010010110011" &
   "001101101111011001010110110001011001111010000010110111101010001000111101" &
   "001101101111011001010110110001011010000000111010100100010101100001101011" &
   "001101101111011001010110110001011010011100011001010111000011000100011110" &
   "001101101111011001010110110001011100001010010100100001111001001111101011" &
   "001101101111011001010110110001100011000010000001001101010001111100000011" &
   "001101101111011001010110110001111110100000110011111010110100100110101000" &
   "001101101111011001010110110011101100011011111110110000111101100011000010" &
   "001101101111011001010110111010100100001000101010001001000101110101110110" &
   "001101101111011001010111010110000010111011010111100010101111010100011100" &
   "001101101111011001011001000011111110000110001011011011011010000100100110" &
   "001101101111011001011111111011101010110000111111011111010010111000110000" &
   "001101101111011001111011011010011101010101011000000010101011111101111101" &
   "001101101111011011101001010101100101111000111111100110100111001110110001" &
   "001101101111100010100001000001101100101001001100010101100110100010000101" &
   "001101101111111101111111101011010000011110011111100101010100101001000100" &
   "001101110001101011111000100100000101110000000001010000111101000101001111" &
   "001101111000100011000001001001011101011001100010001100001001011010010001" &
   "001110010011111001001011100010110111111111011011101100100110101011001010");

  CONSTANT CORDIC_BEH_inv_cordic_scale_hyp_const_slv : 
    STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011000" &
   "010011010100011110100001110010000000001110111011000010001100101001010110" &
   "010011010100011110100001110010000000001110111011000010001100101001001100" &
   "010011010100011110100001110010000000001110111011000010001100101000100110" &
   "010011010100011110100001110010000000001110111011000010001100100110001100" &
   "010011010100011110100001110010000000001110111011000010001100011100100010" &
   "010011010100011110100001110010000000001110111011000010001011110101111001" &
   "010011010100011110100001110010000000001110111011000010001001011011010100" &
   "010011010100011110100001110010000000001110111011000001111111110001000101" &
   "010011010100011110100001110010000000001110111011000001011001001000001000" &
   "010011010100011110100001110010000000001110111010111110111110100100010100" &
   "010011010100011110100001110010000000001110111010110101010100010101000011" &
   "010011010100011110100001110010000000001110111010001110101011010111111111" &
   "010011010100011110100001110010000000001110110111110100000111100011110000" &
   "010011010100011110100001110010000000001110101110001001111000010010111001" &
   "010011010100011110100001110010000000001110000111100000111011001111010100" &
   "010011010100011110100001110010000000001011101100111101000111000001000101" &
   "010011010100011110100001110010000000000010000010101101110110001000000100" &
   "010011010100011110100001110001111111011011011001110000110010100100000011" &
   "010011010100011110100001110001111101000000110101111100100100010011111110" &
   "010011010100011110100001110001110011010110100110101011101011010011000011" &
   "010011010100011110100001110001001100101101101001101000000111000101101100" &
   "010011010100011110100001101110110010001001110101011001110011110101110000" &
   "010011010100011110100001101100010111100110000001001011110011111010010011" &
   "010011010100011110100001100010101101010110110000010011001101100011011101" &
   "010011010100011110100000111100000100011001101100100111001001111000111001" &
   "010011010100011110011110100001100000100101011011011100010111011001101000" &
   "010011010100011110010100110111010001010011110000001000001111101010011101" &
   "010011010100011101101110001110010100000011011000100111110001001001101101" &
   "010011010100011011010011101010011100100111010110000010111100110111101111" &
   "010011010100010001101001011010011000001101011111111111100000101111000111" &
   "010011010011101011000000010000011011101000001000100111110111011101110110" &
   "010011010001010000011001001101010110101001110000111101100001011001111101" &
   "010011001110110110000101100000010111100001001110100101101101011111111110" &
   "010011000101001100001111011001001010101001111010010000110011100100001110" &
   "010010011110011010011101000101100100000011001100011100010011010010000111");

  --ARITHMETIC CONSTANTS.  
  CONSTANT     CORDIC_BEH_pi_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "011001001000011111101101010100010001000010110100011000010001101001100010";
  CONSTANT CORDIC_BEH_pi_3_4_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "010010110110010111110001111111001100110010000111010010001101001111001010";
  CONSTANT CORDIC_BEH_pi_2_4_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "001100100100001111110110101010001000100001011010001100001000110100110010";
  CONSTANT CORDIC_BEH_pi_1_4_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "000110010010000111111011010101000100010000101101000110000100011010011000";
  CONSTANT CORDIC_BEH_neg_pi_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "100110110111100000010010101011101110111101001011100111101110010110011110";
  CONSTANT CORDIC_BEH_neg_pi_3_4_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "101101001001101000001110000000110011001101111000101101110010110000110110";
  CONSTANT CORDIC_BEH_neg_pi_2_4_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "110011011011110000001001010101110111011110100101110011110111001011001110";
  CONSTANT CORDIC_BEH_neg_pi_1_4_rads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "111001101101111000000100101010111011101111010010111001111011100101101000";
  CONSTANT CORDIC_BEH_neg_pi_jrads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "111000000000000000000000000000000000000000000000000000000000000000000000";
  CONSTANT CORDIC_BEH_neg_pi_3_4_jrads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "111010000000000000000000000000000000000000000000000000000000000000000000";
  CONSTANT CORDIC_BEH_neg_pi_2_4_jrads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "111100000000000000000000000000000000000000000000000000000000000000000000";
  CONSTANT CORDIC_BEH_neg_pi_1_4_jrads_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "111110000000000000000000000000000000000000000000000000000000000000000000";
  CONSTANT CORDIC_BEH_zero_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
  "000000000000000000000000000000000000000000000000000000000000000000000000";

--ROM CONSTANTS
  --ROM CONSTANTS are stored as a Qn format STD_LOGIC_VECTOR. 
  --ROM(0) Corresponds to FUNCTION(+0.5)  
  --CORDIC_BEH_atan_rads
  --CORDIC_BEH_atan_jrads
  --CORDIC_BEH_atanh_rads
  --CORDIC_BEH_atanh_jrads
  CONSTANT CORDIC_BEH_atan_rads : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000100000" &
   "000000000000000000000000000000000000000000000000000000000000000001000000" &
   "000000000000000000000000000000000000000000000000000000000000000010000000" &
   "000000000000000000000000000000000000000000000000000000000000000100000000" &
   "000000000000000000000000000000000000000000000000000000000000001000000000" &
   "000000000000000000000000000000000000000000000000000000000000010000000000" &
   "000000000000000000000000000000000000000000000000000000000000100000000000" &
   "000000000000000000000000000000000000000000000000000000000001000000000000" &
   "000000000000000000000000000000000000000000000000000000000010000000000000" &
   "000000000000000000000000000000000000000000000000000000000100000000000000" &
   "000000000000000000000000000000000000000000000000000000001000000000000000" &
   "000000000000000000000000000000000000000000000000000000010000000000000000" &
   "000000000000000000000000000000000000000000000000000000100000000000000000" &
   "000000000000000000000000000000000000000000000000000001000000000000000000" &
   "000000000000000000000000000000000000000000000000000010000000000000000000" &
   "000000000000000000000000000000000000000000000000000100000000000000000000" &
   "000000000000000000000000000000000000000000000000001000000000000000000000" &
   "000000000000000000000000000000000000000000000000010000000000000000000000" &
   "000000000000000000000000000000000000000000000000100000000000000000000000" &
   "000000000000000000000000000000000000000000000001000000000000000000000000" &
   "000000000000000000000000000000000000000000000010000000000000000000000000" &
   "000000000000000000000000000000000000000000000100000000000000000000000000" &
   "000000000000000000000000000000000000000000001000000000000000000000000000" &
   "000000000000000000000000000000000000000000010000000000000000000000000000" &
   "000000000000000000000000000000000000000000100000000000000000000000000000" &
   "000000000000000000000000000000000000000001000000000000000000000000000000" &
   "000000000000000000000000000000000000000010000000000000000000000000000000" &
   "000000000000000000000000000000000000000100000000000000000000000000000000" &
   "000000000000000000000000000000000000001000000000000000000000000000000000" &
   "000000000000000000000000000000000000010000000000000000000000000000000000" &
   "000000000000000000000000000000000000100000000000000000000000000000000000" &
   "000000000000000000000000000000000001000000000000000000000000000000000000" &
   "000000000000000000000000000000000010000000000000000000000000000000000000" &
   "000000000000000000000000000000000100000000000000000000000000000000000000" &
   "000000000000000000000000000000001000000000000000000000000000000000000000" &
   "000000000000000000000000000000010000000000000000000000000000000000000000" &
   "000000000000000000000000000000100000000000000000000000000000000000000000" &
   "000000000000000000000000000001000000000000000000000000000000000000000000" &
   "000000000000000000000000000010000000000000000000000000000000000000000000" &
   "000000000000000000000000000100000000000000000000000000000000000000000000" &
   "000000000000000000000000001000000000000000000000000000000000000000000000" &
   "000000000000000000000000010000000000000000000000000000000000000000000000" &
   "000000000000000000000000011111111111111111111111111111111111111111111101" &
   "000000000000000000000000111111111111111111111111111111111111111111101011" &
   "000000000000000000000001111111111111111111111111111111111111111101010101" &
   "000000000000000000000011111111111111111111111111111111111111101010101011" &
   "000000000000000000000111111111111111111111111111111111111101010101010101" &
   "000000000000000000001111111111111111111111111111111111101010101010101011" &
   "000000000000000000011111111111111111111111111111111101010101010101010101" &
   "000000000000000000111111111111111111111111111111101010101010101010101011" &
   "000000000000000001111111111111111111111111111101010101010101010101010101" &
   "000000000000000011111111111111111111111111101010101010101010101010101110" &
   "000000000000000111111111111111111111111101010101010101010101010110111100" &
   "000000000000001111111111111111111111101010101010101010101011011101110111" &
   "000000000000011111111111111111111101010101010101010101101110111011101111" &
   "000000000000111111111111111111101010101010101010110111011101110111010101" &
   "000000000001111111111111111101010101010101011011101110111011011100101001" &
   "000000000011111111111111101010101010101101110111011101010010111001011010" &
   "000000000111111111111101010101010110111011101101110010100110101011011110" &
   "000000001111111111101010101011011101110101001011101100010010010101000010" &
   "000000011111111101010101101110110111001011001111110111101001110001101101" &
   "000000111111101010110111010100110101010110000101111011011011100011001011" &
   "000001111101011011011101011111100100101100100000001101110101100010101011" &
   "000011101101011000110011100000101011000011011101101001111100010010000110");

  CONSTANT CORDIC_BEH_atan_jrads : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000001010" &
   "000000000000000000000000000000000000000000000000000000000000000000010100" &
   "000000000000000000000000000000000000000000000000000000000000000000101000" &
   "000000000000000000000000000000000000000000000000000000000000000001010001" &
   "000000000000000000000000000000000000000000000000000000000000000010100011" &
   "000000000000000000000000000000000000000000000000000000000000000101000110" &
   "000000000000000000000000000000000000000000000000000000000000001010001100" &
   "000000000000000000000000000000000000000000000000000000000000010100011000" &
   "000000000000000000000000000000000000000000000000000000000000101000101111" &
   "000000000000000000000000000000000000000000000000000000000001010001011111" &
   "000000000000000000000000000000000000000000000000000000000010100010111110" &
   "000000000000000000000000000000000000000000000000000000000101000101111101" &
   "000000000000000000000000000000000000000000000000000000001010001011111001" &
   "000000000000000000000000000000000000000000000000000000010100010111110011" &
   "000000000000000000000000000000000000000000000000000000101000101111100110" &
   "000000000000000000000000000000000000000000000000000001010001011111001100" &
   "000000000000000000000000000000000000000000000000000010100010111110011000" &
   "000000000000000000000000000000000000000000000000000101000101111100110000" &
   "000000000000000000000000000000000000000000000000001010001011111001100001" &
   "000000000000000000000000000000000000000000000000010100010111110011000001" &
   "000000000000000000000000000000000000000000000000101000101111100110000011" &
   "000000000000000000000000000000000000000000000001010001011111001100000111" &
   "000000000000000000000000000000000000000000000010100010111110011000001101" &
   "000000000000000000000000000000000000000000000101000101111100110000011011" &
   "000000000000000000000000000000000000000000001010001011111001100000110111" &
   "000000000000000000000000000000000000000000010100010111110011000001101110" &
   "000000000000000000000000000000000000000000101000101111100110000011011011" &
   "000000000000000000000000000000000000000001010001011111001100000110110111" &
   "000000000000000000000000000000000000000010100010111110011000001101101110" &
   "000000000000000000000000000000000000000101000101111100110000011011011100" &
   "000000000000000000000000000000000000001010001011111001100000110110111001" &
   "000000000000000000000000000000000000010100010111110011000001101101110010" &
   "000000000000000000000000000000000000101000101111100110000011011011100101" &
   "000000000000000000000000000000000001010001011111001100000110110111001010" &
   "000000000000000000000000000000000010100010111110011000001101101110010011" &
   "000000000000000000000000000000000101000101111100110000011011011100100111" &
   "000000000000000000000000000000001010001011111001100000110110111001001110" &
   "000000000000000000000000000000010100010111110011000001101101110010011100" &
   "000000000000000000000000000000101000101111100110000011011011100100111001" &
   "000000000000000000000000000001010001011111001100000110110111001001110010" &
   "000000000000000000000000000010100010111110011000001101101110010011100100" &
   "000000000000000000000000000101000101111100110000011011011100100111001000" &
   "000000000000000000000000001010001011111001100000110110111001001110010000" &
   "000000000000000000000000010100010111110011000001101101110010011100011011" &
   "000000000000000000000000101000101111100110000011011011100100111000001101" &
   "000000000000000000000001010001011111001100000110110111001001101011010101" &
   "000000000000000000000010100010111110011000001101101110010010101101111011" &
   "000000000000000000000101000101111100110000011011011100100000010101111010" &
   "000000000000000000001010001011111001100000110110111000010111111100001110" &
   "000000000000000000010100010111110011000001101101101011101001111011101101" &
   "000000000000000000101000101111100110000011011010101110100100010001010110" &
   "000000000000000001010001011111001100000110110000010111001011110010010001" &
   "000000000000000010100010111110011000001100110111111110110001100001100110" &
   "000000000000000101000101111100110000010100101010000000110010110111000010" &
   "000000000000001010001011111001100000000000100100011011101001111011011010" &
   "000000000000010100010111110010111010111011001100001010101100110111101110" &
   "000000000000101000101111100101001101000110110100001100001100110110111111" &
   "000000000001010001011111000101010100010001110101000100001010101110101000" &
   "000000000010100010111101100001111001011100001010000010011000101001100001" &
   "000000000101000101110101111110000101011001000001000110001001111000010101" &
   "000000001010001011000011010100001100001110010110001001101011101100110000" &
   "000000010100010001000100011101010000011101110111011001101000011011100000" &
   "000000100111111011001110000101101101011110111000111001111010001101111000" &
   "000001001011100100000001010001110110011101111100110000100001111010111100");

  CONSTANT CORDIC_BEH_atanh_rads : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000100000" &
   "000000000000000000000000000000000000000000000000000000000000000001000000" &
   "000000000000000000000000000000000000000000000000000000000000000010000000" &
   "000000000000000000000000000000000000000000000000000000000000000100000000" &
   "000000000000000000000000000000000000000000000000000000000000001000000000" &
   "000000000000000000000000000000000000000000000000000000000000010000000000" &
   "000000000000000000000000000000000000000000000000000000000000100000000000" &
   "000000000000000000000000000000000000000000000000000000000001000000000000" &
   "000000000000000000000000000000000000000000000000000000000010000000000000" &
   "000000000000000000000000000000000000000000000000000000000100000000000000" &
   "000000000000000000000000000000000000000000000000000000001000000000000000" &
   "000000000000000000000000000000000000000000000000000000010000000000000000" &
   "000000000000000000000000000000000000000000000000000000100000000000000000" &
   "000000000000000000000000000000000000000000000000000001000000000000000000" &
   "000000000000000000000000000000000000000000000000000010000000000000000000" &
   "000000000000000000000000000000000000000000000000000100000000000000000000" &
   "000000000000000000000000000000000000000000000000001000000000000000000000" &
   "000000000000000000000000000000000000000000000000010000000000000000000000" &
   "000000000000000000000000000000000000000000000000100000000000000000000000" &
   "000000000000000000000000000000000000000000000001000000000000000000000000" &
   "000000000000000000000000000000000000000000000010000000000000000000000000" &
   "000000000000000000000000000000000000000000000100000000000000000000000000" &
   "000000000000000000000000000000000000000000001000000000000000000000000000" &
   "000000000000000000000000000000000000000000010000000000000000000000000000" &
   "000000000000000000000000000000000000000000100000000000000000000000000000" &
   "000000000000000000000000000000000000000001000000000000000000000000000000" &
   "000000000000000000000000000000000000000010000000000000000000000000000000" &
   "000000000000000000000000000000000000000100000000000000000000000000000000" &
   "000000000000000000000000000000000000001000000000000000000000000000000000" &
   "000000000000000000000000000000000000010000000000000000000000000000000000" &
   "000000000000000000000000000000000000100000000000000000000000000000000000" &
   "000000000000000000000000000000000001000000000000000000000000000000000000" &
   "000000000000000000000000000000000010000000000000000000000000000000000000" &
   "000000000000000000000000000000000100000000000000000000000000000000000000" &
   "000000000000000000000000000000001000000000000000000000000000000000000000" &
   "000000000000000000000000000000010000000000000000000000000000000000000000" &
   "000000000000000000000000000000100000000000000000000000000000000000000000" &
   "000000000000000000000000000001000000000000000000000000000000000000000000" &
   "000000000000000000000000000010000000000000000000000000000000000000000000" &
   "000000000000000000000000000100000000000000000000000000000000000000000000" &
   "000000000000000000000000001000000000000000000000000000000000000000000000" &
   "000000000000000000000000010000000000000000000000000000000000000000000000" &
   "000000000000000000000000100000000000000000000000000000000000000000000011" &
   "000000000000000000000001000000000000000000000000000000000000000000010101" &
   "000000000000000000000010000000000000000000000000000000000000000010101011" &
   "000000000000000000000100000000000000000000000000000000000000010101010101" &
   "000000000000000000001000000000000000000000000000000000000010101010101011" &
   "000000000000000000010000000000000000000000000000000000010101010101010101" &
   "000000000000000000100000000000000000000000000000000010101010101010101011" &
   "000000000000000001000000000000000000000000000000010101010101010101010101" &
   "000000000000000010000000000000000000000000000010101010101010101010101011" &
   "000000000000000100000000000000000000000000010101010101010101010101011000" &
   "000000000000001000000000000000000000000010101010101010101010101100010001" &
   "000000000000010000000000000000000000010101010101010101010110001000100010" &
   "000000000000100000000000000000000010101010101010101011000100010001000100" &
   "000000000001000000000000000000010101010101010101100010001000100010010010" &
   "000000000010000000000000000010101010101010110001000100010001010110100011" &
   "000000000100000000000000010101010101011000100010001001000110101101001110" &
   "000000001000000000000010101010101100010001000101011010001110010011000111" &
   "000000010000000000010101010110001000100100011010111011100010010010110100" &
   "000000100000000010101011000100010101101001101110101101011001101110010110" &
   "000001000000010101100010010001110010011110101011101111011101101001100101" &
   "000010000010110001010111011111010100000010001010001010001101001110010100" &
   "000100011001001111101010011110101010110100000011000010100111110011111001");

  CONSTANT CORDIC_BEH_atanh_jrads : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000001010" &
   "000000000000000000000000000000000000000000000000000000000000000000010100" &
   "000000000000000000000000000000000000000000000000000000000000000000101000" &
   "000000000000000000000000000000000000000000000000000000000000000001010001" &
   "000000000000000000000000000000000000000000000000000000000000000010100011" &
   "000000000000000000000000000000000000000000000000000000000000000101000110" &
   "000000000000000000000000000000000000000000000000000000000000001010001100" &
   "000000000000000000000000000000000000000000000000000000000000010100011000" &
   "000000000000000000000000000000000000000000000000000000000000101000101111" &
   "000000000000000000000000000000000000000000000000000000000001010001011111" &
   "000000000000000000000000000000000000000000000000000000000010100010111110" &
   "000000000000000000000000000000000000000000000000000000000101000101111101" &
   "000000000000000000000000000000000000000000000000000000001010001011111001" &
   "000000000000000000000000000000000000000000000000000000010100010111110011" &
   "000000000000000000000000000000000000000000000000000000101000101111100110" &
   "000000000000000000000000000000000000000000000000000001010001011111001100" &
   "000000000000000000000000000000000000000000000000000010100010111110011000" &
   "000000000000000000000000000000000000000000000000000101000101111100110000" &
   "000000000000000000000000000000000000000000000000001010001011111001100000" &
   "000000000000000000000000000000000000000000000000010100010111110011000001" &
   "000000000000000000000000000000000000000000000000101000101111100110000011" &
   "000000000000000000000000000000000000000000000001010001011111001100000111" &
   "000000000000000000000000000000000000000000000010100010111110011000001101" &
   "000000000000000000000000000000000000000000000101000101111100110000011011" &
   "000000000000000000000000000000000000000000001010001011111001100000110111" &
   "000000000000000000000000000000000000000000010100010111110011000001101110" &
   "000000000000000000000000000000000000000000101000101111100110000011011011" &
   "000000000000000000000000000000000000000001010001011111001100000110110111" &
   "000000000000000000000000000000000000000010100010111110011000001101101110" &
   "000000000000000000000000000000000000000101000101111100110000011011011100" &
   "000000000000000000000000000000000000001010001011111001100000110110111001" &
   "000000000000000000000000000000000000010100010111110011000001101101110010" &
   "000000000000000000000000000000000000101000101111100110000011011011100101" &
   "000000000000000000000000000000000001010001011111001100000110110111001010" &
   "000000000000000000000000000000000010100010111110011000001101101110010011" &
   "000000000000000000000000000000000101000101111100110000011011011100100111" &
   "000000000000000000000000000000001010001011111001100000110110111001001110" &
   "000000000000000000000000000000010100010111110011000001101101110010011100" &
   "000000000000000000000000000000101000101111100110000011011011100100111001" &
   "000000000000000000000000000001010001011111001100000110110111001001110010" &
   "000000000000000000000000000010100010111110011000001101101110010011100100" &
   "000000000000000000000000000101000101111100110000011011011100100111001000" &
   "000000000000000000000000001010001011111001100000110110111001001110010010" &
   "000000000000000000000000010100010111110011000001101101110010011100101001" &
   "000000000000000000000000101000101111100110000011011011100100111001111010" &
   "000000000000000000000001010001011111001100000110110111001001111000111010" &
   "000000000000000000000010100010111110011000001101101110010100011010100101" &
   "000000000000000000000101000101111100110000011011011100101101111011000111" &
   "000000000000000000001010001011111001100000110110111010000100100101110100" &
   "000000000000000000010100010111110011000001101101111001001111001000011000" &
   "000000000000000000101000101111100110000011011100011011001101110110110100" &
   "000000000000000001010001011111001100000110111101111100011000011110000101" &
   "000000000000000010100010111110011000001110100100101000010111000000000101" &
   "000000000000000101000101111100110000100010001111001101011110101010111001" &
   "000000000000001010001011111001100001101101001110000001001000011010010001" &
   "000000000000010100010111110011001000100000011000110110100000101110110010" &
   "000000000000101000101111100110111001110000011001101010101011111010010101" &
   "000000000001010001011111010010111001011110100000111000011000111110011000" &
   "000000000010100010111111001110100011000001101001001111110100011101111100" &
   "000000000101000110000011100011010010000110010010000101010101101000101111" &
   "000000001010001100101111111101110100100111000101100100011110011011011100" &
   "000000010100011110101001101111110000110110010010110011101110001001010111" &
   "000000101001101000000011010110000100100011111110110010011001011000110100" &
   "000001011001100001011110001000110111101101011100101111010000001101101110");
  
END cordic_pack_beh;

PACKAGE BODY cordic_pack_beh is

  -- This function is used to determine if a cordic functional 
  -- configuration requires an input.
  FUNCTION CORDIC_BEH_funct_has_port(cordic_funct, position: INTEGER) RETURN INTEGER IS 
    VARIABLE in_out_vect_v : STD_LOGIC_VECTOR(CORDIC_BEH_cordic_io_cnt-1 DOWNTO 0);
    VARIABLE in_out_bit_v : STD_LOGIC;
    VARIABLE in_out_tmp_v : INTEGER;
  BEGIN
  	
    in_out_bit_v := '0';
    -- The in_out_vect represents the valid
    -- I/O for the selected CORDIC function.
    -- "X_IN,Y_IN,PHA_IN,X_OUT,Y_OUT,PHA_OUT" 
    CASE cordic_funct IS
      WHEN CORDIC_BEH_f_rotate => -- C_ROTATE 
        in_out_vect_v := "111110";
      WHEN CORDIC_BEH_f_translate => -- C_VECTOR 
        in_out_vect_v := "110101";
      WHEN CORDIC_BEH_f_sin_cos|CORDIC_BEH_f_sinh_cosh => -- C_SIN_COS or C_SINH_COSH
        in_out_vect_v := "001110";
      WHEN CORDIC_BEH_f_atan|CORDIC_BEH_f_atanh => -- C_ATAN or C_ATANH 
        in_out_vect_v := "110001";
      WHEN CORDIC_BEH_f_sqrt => -- C_SQRT 
        in_out_vect_v := "100100";
      WHEN OTHERS => -- DEFAULT.
        in_out_vect_v := "111111";
    END CASE;
    
    in_out_bit_v := in_out_vect_v(position);
    in_out_tmp_v := 0;
    IF (in_out_bit_v = '1') THEN
      in_out_tmp_v := 1;	
    END IF;    
    RETURN in_out_tmp_v;
  END; -- FUNCTION CORDIC_BEH_funct_has_port;
  
  FUNCTION CORDIC_BEH_get_transform_type(cordic_funct : INTEGER)RETURN INTEGER IS
    VARIABLE transform_type_v : INTEGER;
  BEGIN
    transform_type_v := CORDIC_BEH_trig_transform;
  	IF ((cordic_funct = CORDIC_BEH_f_sinh_cosh) OR (cordic_funct = CORDIC_BEH_f_atanh)) THEN
      transform_type_v := CORDIC_BEH_hyp_transform;
  	END IF; RETURN transform_type_v; 
  END; -- FUNCTION CORDIC_BEH_get_transform_type;
  
  FUNCTION CORDIC_BEH_get_eng_mode(cordic_funct: INTEGER) RETURN STD_LOGIC IS
    VARIABLE engine_mode_v : STD_LOGIC := '0';
  BEGIN
    engine_mode_v := '0';
    IF((cordic_funct=CORDIC_BEH_f_translate)OR(cordic_funct=CORDIC_BEH_f_atan)OR
       (cordic_funct=CORDIC_BEH_f_atanh))THEN
      engine_mode_v := '1';
    END IF;
    RETURN engine_mode_v;
  END; -- FUNCTION CORDIC_BEH_get_eng_mode
  
  FUNCTION CORDIC_BEH_get_iterations_int(coarse_rotate : INTEGER; cordic_funct : INTEGER; iterations : INTEGER; 
             output_width : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE iterations_int_v : INTEGER;
    VARIABLE iterations_v : INTEGER;
    VARIABLE rnd_mode_int_v : INTEGER;
  BEGIN
    --If the user selects a number of iterations, ie iterations /= 0, use this.
    IF (iterations /= 0) THEN
      iterations_v := iterations;
    --Otherwise Calcualte appropriate precision.
    ELSE -- (iterations = 0) THEN
      IF (cordic_funct /= CORDIC_BEH_f_sqrt) THEN
        IF (coarse_rotate = 1) THEN
          iterations_int_v := output_width-2;
        ELSE
          iterations_int_v := output_width;
        END IF;
        IF (CORDIC_BEH_get_transform_type(cordic_funct) = CORDIC_BEH_hyp_transform) THEN
          IF (iterations_v >= 13) THEN iterations_v := iterations_v + 2;
          ELSIF (iterations_v >= 4) THEN iterations_v := iterations_v + 1;
          ELSE iterations_v := iterations_int_v;
          END IF;
        ELSE
          iterations_v := iterations_int_v;
        END IF;
      ELSE
        rnd_mode_int_v := CORDIC_BEH_get_rnd_mode_int(cordic_funct,round_mode);
        iterations_v := output_width + CORDIC_BEH_get_round_ext(rnd_mode_int_v);
      END IF;
    END IF;
    RETURN iterations_v;
  END; -- FUNCTION CORDIC_BEH_get_iterations_int;

  FUNCTION CORDIC_BEH_get_sqrt_output_width(input_width : INTEGER; output_width : INTEGER; data_format : INTEGER) RETURN INTEGER IS
    VARIABLE output_width_v : INTEGER;
  BEGIN
    IF data_format = CORDIC_BEH_format_usig_int THEN
      output_width_v := (input_width+2)/2;
    ELSE
      output_width_v := output_width;
    END IF;
    RETURN output_width_v;
  END; -- FUNCTION CORDIC_BEH_get_sqrt_output_width;

  FUNCTION CORDIC_BEH_get_precision_int(cordic_funct : INTEGER; data_format : INTEGER;input_width : INTEGER;
             iterations_int : INTEGER; output_width : INTEGER; precision : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE precision_v : INTEGER;
    VARIABLE rnd_mode_int_v : INTEGER;
    VARIABLE output_width_int_v : INTEGER; 
  BEGIN
    --If the user selects a precision, ie precision /= 0, use this.
    precision_v := precision;
    -- Otherwise Calculate an appropriate precision
    IF (precision = 0) THEN
      IF (cordic_funct /= CORDIC_BEH_f_sqrt) THEN
        precision_v := CORDIC_BEH_log2_rnd_up(iterations_int) + output_width;
      ELSE -- if cordic_funct = sqrt
        output_width_int_v := CORDIC_BEH_get_sqrt_output_width(input_width, output_width, data_format);
        IF (round_mode = CORDIC_BEH_round_truncate) THEN
          precision_v := output_width_int_v;
        END IF;
        IF ((round_mode = CORDIC_BEH_round_pos_inf) OR (round_mode = CORDIC_BEH_round_pos_neg_inf)) THEN
          precision_v := output_width_int_v + 1;
        END IF;
        IF (round_mode = CORDIC_BEH_round_nearest_even) THEN
          precision_v := output_width_int_v + 2;
        END IF;
      END IF;        
    END IF;
    RETURN precision_v;
  END; --FUNCTION CORDIC_BEH_get_precision_int;

  FUNCTION CORDIC_BEH_get_rnd_mode_int(cordic_funct : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE round_mode_v : INTEGER;
  BEGIN
  	round_mode_v := round_mode;
    IF (cordic_funct = CORDIC_BEH_f_sqrt) AND (round_mode = CORDIC_BEH_round_pos_neg_inf) THEN
      round_mode_v := CORDIC_BEH_round_pos_inf;
    END IF;
    RETURN round_mode_v;
  END; --FUNCTION CORDIC_BEH_get_rnd_mode_int;

  FUNCTION CORDIC_BEH_get_scale_comp_int(family : STRING; scale_comp : INTEGER) RETURN INTEGER IS
    VARIABLE scale_comp_v : INTEGER;
  BEGIN
    IF ( (scale_comp = 0) OR (scale_comp = 1) ) THEN 
      scale_comp_v := scale_comp;
    ELSE
      IF ( (scale_comp = 2) AND 
           ( (family = "virtex2") OR (family = "virtex2p") ) )THEN 
        scale_comp_v := 2;
      ELSIF ( ((scale_comp = 2) AND (family = "virtex4")) OR (scale_comp = 3) )THEN 
        scale_comp_v := 3;
      ELSE scale_comp_v := 1;    
      END IF;
    END IF;
    RETURN scale_comp_v;
  END; --FUNCTION CORDIC_BEH_get_scale_comp_int;

  FUNCTION CORDIC_BEH_select_slv_int (a:STD_LOGIC_VECTOR; b:STD_LOGIC_VECTOR; sel : INTEGER) 
    RETURN STD_LOGIC_VECTOR IS
  BEGIN
    IF (sel = 0) THEN
      RETURN a;
    ELSE
      RETURN b;
    END IF;
  END; --FUNCTION CORDIC_BEH_select_slv_int;

  FUNCTION CORDIC_BEH_gen_ctrl_width(coarse_rotate : INTEGER) RETURN INTEGER IS
    VARIABLE gen_ctrl_width_v : INTEGER;
  BEGIN
  	gen_ctrl_width_v := 1;
    IF (coarse_rotate = 1) THEN
      gen_ctrl_width_v := gen_ctrl_width_v + 2;
    END IF;
    RETURN gen_ctrl_width_v;
  END; --FUNCTION CORDIC_BEH_gen_ctrl_width;
  
  FUNCTION CORDIC_BEH_get_current_iteration(I : INTEGER;transform_type : INTEGER)RETURN INTEGER IS 
    VARIABLE iteration_v : INTEGER;
  BEGIN
    iteration_v := I;
  	IF (transform_type = CORDIC_BEH_hyp_transform) THEN
      IF (I > 13) THEN iteration_v := I - 2;
      ELSIF (I > 3) THEN iteration_v := I - 1;
      ELSE iteration_v := I;
      END IF;
  	END IF; RETURN iteration_v; 
  END; --FUNCTION CORDIC_BEH_get_current_iteration;

  FUNCTION CORDIC_BEH_get_round_ext(round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE rnd_ext_v : INTEGER;
  BEGIN
    rnd_ext_v := 0;
    IF (round_mode = CORDIC_BEH_round_pos_inf) THEN
      rnd_ext_v := 1;
    END IF;
    IF (round_mode = CORDIC_BEH_round_pos_neg_inf) THEN
      rnd_ext_v := 2;
    END IF;
    IF (round_mode = CORDIC_BEH_round_nearest_even) THEN
      rnd_ext_v := 2;
    END IF;
    RETURN rnd_ext_v;
  END; --FUNCTION CORDIC_BEH_get_round_ext;

  FUNCTION CORDIC_BEH_get_rnd_pipe_int(p_pipeline_mode:INTEGER; p_reg_outputs:INTEGER)RETURN INTEGER IS
    VARIABLE rnd_pipe_mode_v : INTEGER;
  BEGIN
    rnd_pipe_mode_v := p_pipeline_mode;
    IF (p_reg_outputs = 1) THEN
      rnd_pipe_mode_v := CORDIC_BEH_pipe_max; 	
    END IF;
    RETURN rnd_pipe_mode_v;
  END; --FUNCTION CORDIC_BEH_get_rnd_pipe_int;
  
  FUNCTION CORDIC_BEH_get_mult_type_int(scale_comp : INTEGER) RETURN INTEGER IS
    VARIABLE mult_type_v : INTEGER;
  BEGIN
    -- constant PARALLEL     : integer := 0;  -- ip var: c_parallel
    -- constant V2_PARALLEL  : integer := 1;  -- ip_var: c_v2_parallel
    -- constant CCM          : integer := 2;  -- ip_var: c_ccm
    -- constant STATIC_RCCM  : integer := 3;  -- ip_var: c_static_rccm
    -- constant DYNAMIC_RCCM : integer := 4;  -- ip_var: c_dynamic_rccm
    -- constant V4_PARALLEL  : integer := 5;
    IF (scale_comp = CORDIC_BEH_scale_none) THEN mult_type_v := 0; 
    ELSIF (scale_comp = CORDIC_BEH_scale_ccm) THEN mult_type_v := 2; 
    ELSIF (scale_comp = CORDIC_BEH_scale_block) THEN mult_type_v := 1; 
    ELSE mult_type_v := 5;-- (scale_comp = CORDIC_BEH_scale_dsp48) 
    END IF;
    RETURN mult_type_v;
  END; --FUNCTION CORDIC_BEH_get_mult_type_int;
  
--  FUNCTION CORDIC_BEH_get_mult_width_int(output_width : INTEGER; mult_type : INTEGER) RETURN INTEGER IS
--    VARIABLE mult_width_int_v : INTEGER;
--  BEGIN
--    --If mult is not a fixed CCM mult then extend internal width by 2.
--    --to compenate for scale for scale value input being Q1 format
--    IF (mult_type /= 2) THEN mult_width_int_v := output_width +2; 
--    ELSE mult_width_int_v := output_width; 
--    END IF;
--    RETURN mult_width_int_v;
--  END; --FUNCTION CORDIC_BEH_get_mult_width_int;
  
  FUNCTION CORDIC_BEH_get_rom_blk_num(rom_depth : INTEGER) RETURN INTEGER IS
    VARIABLE blk_num_v : INTEGER;
  BEGIN
    blk_num_v := 1;
    IF rom_depth > CORDIC_BEH_rom_block_depth THEN blk_num_v := 2; END IF;
    RETURN blk_num_v;    
  END; --FUNCTION CORDIC_BEH_get_rom_blk_num;
  
  FUNCTION CORDIC_BEH_log2_rnd_up (x : INTEGER) RETURN INTEGER IS
    VARIABLE pow_v : INTEGER;
    VARIABLE cnt_v : INTEGER;
  BEGIN 
    pow_v := 1;
    cnt_v := 0;
    WHILE (x > pow_v) LOOP
      pow_v := pow_v + pow_v; 
      cnt_v := cnt_v + 1;
    END LOOP;
    RETURN cnt_v;
  END; -- FUNCTION CORDIC_BEH_log2_rnd_up;
  
  FUNCTION getLatency(architecture_sel : INTEGER; coarse_rotate : INTEGER; cordic_function : INTEGER;
                      data_format : INTEGER; family : STRING; input_width : INTEGER; iterations : INTEGER; output_width : INTEGER;
                      pipeline_mode : INTEGER; precision : INTEGER; reg_inputs : INTEGER; reg_outputs: INTEGER;
                      round_mode : INTEGER; scale_comp : INTEGER)
                      RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
    VARIABLE iterations_int_v : INTEGER;
    VARIABLE precision_int_v : INTEGER;
    VARIABLE scale_comp_int_v : INTEGER;
  BEGIN
    iterations_int_v := CORDIC_BEH_get_iterations_int(coarse_rotate, cordic_function, iterations, output_width, 
                         round_mode);
    precision_int_v := CORDIC_BEH_get_precision_int(cordic_function, data_format, input_width, iterations_int_v, 
                         output_width, precision, round_mode);
    scale_comp_int_v := CORDIC_BEH_get_scale_comp_int(family, scale_comp);
    latency_v := 0;
    IF ((cordic_function = CORDIC_BEH_f_rotate) OR (cordic_function = CORDIC_BEH_f_sin_cos) OR
        (cordic_function = CORDIC_BEH_f_sinh_cosh) OR (cordic_function = CORDIC_BEH_f_translate) OR
        (cordic_function = CORDIC_BEH_f_atan) OR (cordic_function = CORDIC_BEH_f_atanh))
    THEN
        latency_v := latency_v + 
                     CORDIC_BEH_get_inp_config_latency(architecture_sel, coarse_rotate, cordic_function, 
                       pipeline_mode, reg_inputs) +
                     CORDIC_BEH_get_engine_latency(architecture_sel, iterations_int_v, pipeline_mode) +
                     CORDIC_BEH_get_out_config_latency(architecture_sel,coarse_rotate, cordic_function, 
                       iterations_int_v, pipeline_mode, precision_int_v, reg_outputs, round_mode, scale_comp_int_v);
    END IF;
    IF (cordic_function = CORDIC_BEH_f_sqrt)
    THEN
      latency_v := CORDIC_BEH_get_sqrt_latency(data_format,input_width,output_width,pipeline_mode,precision_int_v,
                     reg_inputs,reg_outputs,round_mode);
    END IF;
    RETURN latency_v;
  END; --FUNCTION getLatency;
  
  FUNCTION CORDIC_BEH_get_inp_config_latency(architecture_sel : INTEGER; coarse_rotate : INTEGER; 
             cordic_function : INTEGER; pipeline_mode : INTEGER; reg_inputs : INTEGER)
             RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF (reg_inputs = 1) THEN
      latency_v := latency_v + 1;
    END IF;
    IF ( (coarse_rotate = 1) AND (architecture_sel = CORDIC_BEH_para_arch) AND
         ((pipeline_mode = CORDIC_BEH_pipe_max) OR (pipeline_mode = CORDIC_BEH_pipe_opt))
         ) THEN
      latency_v := latency_v + 2;    	
    END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_BEH_get_inp_config_latency;

  FUNCTION CORDIC_BEH_get_engine_latency(architecture_sel : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER)
    RETURN INTEGER IS
      VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF ((pipeline_mode = CORDIC_BEH_pipe_opt) OR (pipeline_mode = CORDIC_BEH_pipe_max)) THEN
      latency_v := latency_v + iterations_int;
--      IF (architecture_sel = CORDIC_BEH_wser_arch) THEN
--        latency_v := latency_v + 1;
--      END IF;
    END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_BEH_get_engine_latency;

  FUNCTION CORDIC_BEH_get_out_config_latency(architecture_sel : INTEGER; coarse_rotate : INTEGER; 
             cordic_function : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER; precision_int : INTEGER;
             reg_outputs : INTEGER; round_mode : INTEGER; scale_comp_int : INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
    VARIABLE round_pipe_v : INTEGER;
  BEGIN
    latency_v := 0;
    -- Realign ND with Internal data for WSER Architecture.
    IF ( architecture_sel = CORDIC_BEH_wser_arch) THEN
      latency_v := latency_v + 2;
    END IF;
    --Coarse Output Rotation
    IF ( (coarse_rotate = 1) AND ((pipeline_mode = CORDIC_BEH_pipe_opt) OR (pipeline_mode = CORDIC_BEH_pipe_max)) ) THEN
      latency_v := latency_v + 2;
    END IF;
    --ccm_latency
    IF ((scale_comp_int = CORDIC_BEH_scale_ccm) OR (scale_comp_int = CORDIC_BEH_scale_block)OR 
        (scale_comp_int = CORDIC_BEH_scale_dsp48)) THEN 
      latency_v := latency_v +
        CORDIC_BEH_get_scale_latency(cordic_function, precision_int, iterations_int, pipeline_mode,scale_comp_int);
    END IF;
    --Cordic Round
    round_pipe_v := CORDIC_BEH_get_rnd_pipe_int(pipeline_mode, reg_outputs);
    latency_v := latency_v + CORDIC_BEH_get_round_latency(round_pipe_v,round_mode);
    RETURN latency_v;
  END; --FUNCTION CORDIC_BEH_get_out_config_latency

  FUNCTION CORDIC_BEH_get_scale_latency(cordic_function : INTEGER; precision_int : INTEGER; iterations_int : INTEGER;
                                 pipeline_mode: INTEGER; scale_comp_int: INTEGER)RETURN INTEGER IS
    VARIABLE mult_type_v : INTEGER;
    VARIABLE scale_str_v : string(1 TO precision_int);
    VARIABLE scale_latency_v : INTEGER;
  BEGIN
  
    IF (pipeline_mode = CORDIC_BEH_pipe_none) THEN 
      scale_latency_v := 0;
    ELSE 
      mult_type_v := CORDIC_BEH_get_mult_type_int(scale_comp_int);
      scale_str_v := CORDIC_BEH_inv_cordic_scale_str(cordic_function,iterations_int,precision_int);

      scale_latency_v := get_mult_gen_v7_0_latency(			 
            precision_int,  -- c_a_width
            precision_int,  -- c_b_width
            1,               -- c_b_type
            0,               -- c_has_a_signed
            1,              -- c_reg_a_b_inputs
            0,               -- c_mem_type
            1,               -- c_pipeline
            mult_type_v,     -- c_mult_type
            0,               -- c_has_loadb
            precision_int,  -- c_baat
            scale_str_v,	 -- c_b_value
            0,               -- c_a_type
            0,               -- c_has_swapb
            0,               -- c_sqm_type
            0,               -- c_has_aclr    
            0,               -- c_has_sclr    
            1,               -- c_has_ce      
            1,               -- c_sync_enable 
            0,               -- c_has_nd      
            1,     -- c_has_q       
            8                -- bram_addr_width
      ) + 1;--mult_latency calculates not registered latency.
    END IF;
    RETURN scale_latency_v;
  END; --FUNCTION CORDIC_BEH_get_scale_latency;

  FUNCTION CORDIC_BEH_get_round_latency(pipeline_mode : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF (pipeline_mode = CORDIC_BEH_pipe_none) -- No Pipelining 
    THEN
      latency_v := 0;
    ELSE
      latency_v := 1;
  	END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_BEH_get_round_latency;

  FUNCTION CORDIC_BEH_get_sqrt_latency(data_format:INTEGER;input_width:INTEGER;output_width:INTEGER;
                      pipeline_mode:INTEGER;precision:INTEGER;reg_inputs:INTEGER; reg_outputs:INTEGER;
                      round_mode:INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER; 
    VARIABLE precision_int_v : INTEGER; 
  BEGIN
    latency_v := 0;
    precision_int_v := CORDIC_BEH_get_precision_int(CORDIC_BEH_f_sqrt,data_format,input_width,0,output_width,
                                                    precision,round_mode);
    --Optional input register
    IF reg_inputs = 1 THEN	latency_v := latency_v + 1; END IF;
    --Optimal Pipelining
    IF pipeline_mode = CORDIC_BEH_pipe_opt THEN
      latency_v := latency_v + (precision_int_v-1)/2 + 1;
    END IF;
    --Maximal Pipelining
    IF (pipeline_mode = CORDIC_BEH_pipe_max) THEN
    	latency_v := latency_v + precision_int_v-2 + 1;
    END IF;
    --Optional output register (note only require if engine is async)
    IF pipeline_mode = CORDIC_BEH_pipe_none THEN
      IF reg_outputs = 1 THEN
    	latency_v := latency_v + 1;
      END IF;
    END IF;
    RETURN latency_v;
  END; -- FUNCTION CORDIC_BEH_get_sqrt_latency;

  FUNCTION CORDIC_BEH_get_rfd_latency(architecture_sel : INTEGER;coarse_rotate : INTEGER;cordic_function : INTEGER;
                      iterations_int : INTEGER;pipeline_mode : INTEGER;reg_inputs : INTEGER) 
                      RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF (architecture_sel = CORDIC_BEH_wser_arch) THEN
      IF ( (cordic_function = CORDIC_BEH_f_rotate)    OR (cordic_function = CORDIC_BEH_f_sin_cos) OR
           (cordic_function = CORDIC_BEH_f_sinh_cosh) OR (cordic_function = CORDIC_BEH_f_translate) OR
           (cordic_function = CORDIC_BEH_f_atan)      OR (cordic_function = CORDIC_BEH_f_atanh) )
      THEN
        latency_v := latency_v +
                     CORDIC_BEH_get_inp_config_latency(architecture_sel, coarse_rotate, cordic_function,
                                            pipeline_mode, reg_inputs) +
                     CORDIC_BEH_get_engine_latency(architecture_sel, iterations_int, pipeline_mode);
      END IF;
    END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_BEH_get_rfd_latency;
 
  -- Functions to fix XCC Shortcomings
  -- Replaces the following code "sample <= (others => );"
  FUNCTION CORDIC_BEH_set_vect_slv(a: STD_LOGIC_VECTOR; val: STD_LOGIC) RETURN STD_LOGIC_VECTOR IS
    VARIABLE slv_v : STD_LOGIC_VECTOR(a'LENGTH-1 DOWNTO 0);
  BEGIN
  	FOR I IN a'LENGTH-1 DOWNTO 0 LOOP
  	  slv_v(I) := val;	
  	END LOOP;
    RETURN slv_v;
  END; -- FUNCTION CORDIC_BEH_set_vect_slv;

  -- Replaces the following code "SIGNAL sample:STD_LOGIC_VECTOR := (others => );"
  FUNCTION CORDIC_BEH_init_vect_slv(len: INTEGER; val: STD_LOGIC) RETURN STD_LOGIC_VECTOR IS                  
    VARIABLE  slv_v : STD_LOGIC_VECTOR(len-1 DOWNTO 0);
  BEGIN
  	FOR I IN len-1 DOWNTO 0 LOOP
  	   slv_v(I) := val;	
  	END LOOP;
    RETURN  slv_v;
  END; -- FUNCTION CORDIC_BEH_init_vect_slv;

  --Conversion Functions
  FUNCTION CORDIC_BEH_slv_to_str(a: STD_LOGIC_VECTOR) RETURN STRING IS
    VARIABLE str_tmp_v : STRING(1 TO a'length);
  BEGIN
    FOR I IN a'length-1 DOWNTO 0 LOOP
	  str_tmp_v(a'length - I) := 'U';-- Default Assigment = 'U'
      IF (a(a'low+I) = 'X') THEN str_tmp_v(a'length - I) := 'X'; END IF;
      IF (a(a'low+I) = 'Z') THEN str_tmp_v(a'length - I) := 'Z'; END IF;
      IF (a(a'low+I) = '0') THEN str_tmp_v(a'length - I) := '0'; END IF;
      IF (a(a'low+I) = '1') THEN str_tmp_v(a'length - I) := '1'; END IF;
    END LOOP;
    RETURN str_tmp_v;
  END; -- FUNCTION CORDIC_BEH_slv_to_str;

  FUNCTION CORDIC_BEH_str_to_slv(a: STRING) RETURN STD_LOGIC_VECTOR IS
    VARIABLE slv_tmp_v : STD_LOGIC_VECTOR(a'length-1 DOWNTO 0);
  BEGIN
    FOR I IN a'length-1 DOWNTO 0 LOOP
	  slv_tmp_v(I) := 'U';-- Default Assigment = 'U'
      IF (a(a'length-I) = 'X') THEN slv_tmp_v(I) := 'X'; END IF;
      IF (a(a'length-I) = 'Z') THEN slv_tmp_v(I) := 'Z'; END IF;
      IF (a(a'length-I) = '0') THEN slv_tmp_v(I) := '0'; END IF;
      IF (a(a'length-I) = '1') THEN slv_tmp_v(I) := '1'; END IF;
    END LOOP;
    RETURN slv_tmp_v;
  END; -- FUNCTION CORDIC_BEH_str_to_slv;

  FUNCTION CORDIC_BEH_nat_to_slv(a: NATURAL; len: INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE pow_v : INTEGER;
    VARIABLE a_int_v : INTEGER;
    VARIABLE a_tmp_v : INTEGER;
    VARIABLE a_vect_v : STD_LOGIC_VECTOR(len-1 DOWNTO 0);
  BEGIN
      pow_v:=1; FOR I IN len DOWNTO 1 LOOP pow_v := pow_v + pow_v; END LOOP;
      IF (a >= pow_v) THEN
        ASSERT FALSE REPORT "Integer input is too positive. Saturating output" SEVERITY warning;   
        a_int_v := (pow_v) - 1;
      ELSE
        a_int_v := a;
      END IF;
      FOR I IN len-1 DOWNTO 0 LOOP
        pow_v := pow_v / 2;
        a_tmp_v := a_int_v - pow_v;
        a_vect_v(I) := '0';
        IF (a_tmp_v >= 0) THEN
          a_vect_v(I) := '1';
      	  a_int_v := a_tmp_v;
        END IF;
      END LOOP;
      RETURN a_vect_v;
    END; -- FUNCTION CORDIC_BEH_nat_to_slv;      

  FUNCTION CORDIC_BEH_slv_to_nat(a: STD_LOGIC_VECTOR) RETURN NATURAL IS
    VARIABLE pow_v : NATURAL;
    VARIABLE nat_v : NATURAL;
  BEGIN
    nat_v := 0;
    pow_v := 1;
    FOR I IN a'low TO a'high LOOP
      IF (a(I) = '1') THEN
        nat_v := nat_v + pow_v;
      END IF;
      pow_v := pow_v + pow_v;	
    END LOOP;
    RETURN nat_v;    
  END; --FUNCTION CORDIC_BEH_slv_to_nat;

  FUNCTION CORDIC_BEH_int_to_slv(a: INTEGER; len: INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE pow_v : INTEGER;
    VARIABLE a_int_v : INTEGER;
    VARIABLE a_tmp_v : INTEGER;
    VARIABLE a_vect_v : STD_LOGIC_VECTOR(len-1 DOWNTO 0);
  BEGIN
    pow_v:=1; FOR I IN len-1 DOWNTO 1 LOOP pow_v := pow_v + pow_v; END LOOP;
    IF ( a < -pow_v ) THEN
      ASSERT FALSE REPORT "Integer input is too negative. Saturating output" SEVERITY warning;   
      a_int_v := pow_v;
    ELSIF (a >= pow_v) THEN
      ASSERT FALSE REPORT "Integer input is too positive. Saturating output" SEVERITY warning;   
      a_int_v := pow_v - 1;
    ELSIF (a >= 0) THEN
      a_int_v := a;
    ELSE
      a_int_v := pow_v * 2 + a;
    END IF;
    FOR I IN len-1 DOWNTO 0 LOOP
      a_tmp_v := a_int_v - pow_v;
      a_vect_v(I) := '0';
      IF (a_tmp_v >= 0) THEN
        a_vect_v(I) := '1';
    	  a_int_v := a_tmp_v;
      END IF;
      pow_v := pow_v / 2;
    END LOOP;
    RETURN a_vect_v;
  END; -- FUNCTION CORDIC_BEH_int_to_slv;      

  FUNCTION CORDIC_BEH_int_to_sl(a : INTEGER) RETURN STD_LOGIC IS
    VARIABLE int_to_sl_v : STD_LOGIC; 
  BEGIN 
    int_to_sl_v := '0';IF (a /= 0) THEN int_to_sl_v := '1'; END IF; RETURN int_to_sl_v;
  END;-- FUNCTION CORDIC_BEH_int_to_sl;

  FUNCTION CORDIC_BEH_slv_to_int(a: STD_LOGIC_VECTOR) RETURN INTEGER IS
    VARIABLE pow_v : INTEGER;
    VARIABLE int_v : INTEGER;
  BEGIN
    int_v := 0;
    pow_v := 1;
    FOR I IN a'low TO a'high-1 LOOP
      IF (a(I) = '1') THEN
        int_v := int_v + pow_v;
      END IF;
      pow_v := pow_v + pow_v;	
    END LOOP;
    IF a(a'high) = '1' THEN
      int_v := int_v - pow_v;  
    END IF;
    RETURN int_v;    
  END; --FUNCTION CORDIC_BEH_int_to_sl;

  FUNCTION CORDIC_BEH_sl_to_int(a : STD_LOGIC) RETURN INTEGER IS
    VARIABLE sl_to_int_v : INTEGER; 
  BEGIN 
    sl_to_int_v := 1;IF (a /= '1') THEN sl_to_int_v := 0; END IF; RETURN sl_to_int_v;
  END; --FUNCTION CORDIC_BEH_sl_to_int;
  
  FUNCTION CORDIC_BEH_real_to_slv(a:REAL; len:INTEGER; fmt:INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE a_int_v : REAL := 0.0;
    VARIABLE a_tmp_v : REAL := 0.0;
    VARIABLE pow_int_v : REAL := 0.0;
    VARIABLE pow_lsb_v : REAL := 0.0;
    VARIABLE a_vect_v: STD_LOGIC_VECTOR(len-1 DOWNTO 0);
  BEGIN
    pow_int_v := 1.0; FOR I IN fmt DOWNTO 1 LOOP pow_int_v := pow_int_v + pow_int_v; END LOOP;
    pow_lsb_v := pow_int_v; FOR I IN len-1 DOWNTO 1 LOOP pow_lsb_v := pow_lsb_v * 0.5; END LOOP; 
    IF ( a < -pow_int_v ) THEN
      ASSERT FALSE REPORT "Real value too negative. Saturating output" SEVERITY warning;   
      a_int_v := pow_int_v;
    ELSIF (a >= pow_int_v) THEN
      ASSERT FALSE REPORT "Real value too positive. Saturating output" SEVERITY warning;   
      a_int_v := pow_int_v - pow_lsb_v;
    ELSIF (a >= 0.0) THEN
      a_int_v := a;
    ELSE
      a_int_v := pow_int_v * 2.0 + a;
    END IF;
    FOR I IN len-1 DOWNTO 0 LOOP
      a_tmp_v := a_int_v - pow_int_v;
      a_vect_v(I) := '0';
      IF (a_tmp_v >= REAL(0)) THEN
        a_vect_v(I) := '1';
    	  a_int_v := a_tmp_v;
      END IF;
      pow_int_v := pow_int_v * 0.5;
    END LOOP;
    RETURN a_vect_v;
  END; -- FUNCTION CORDIC_BEH_real_to_slv;      

  FUNCTION CORDIC_BEH_slv_to_real(a:STD_LOGIC_VECTOR;fmt:Integer) RETURN REAL IS
    VARIABLE pow_int_v : REAL;
    VARIABLE pow_lsb_v : REAL;
    VARIABLE a_tmp_v : REAL;
    VARIABLE a_adj_v : REAL;
  BEGIN
    pow_int_v:= 1.0; FOR I IN fmt DOWNTO 1 LOOP pow_int_v := pow_int_v + pow_int_v; END LOOP;
    pow_lsb_v:= pow_int_v; FOR I IN a'length-1 DOWNTO 1 LOOP pow_lsb_v := pow_lsb_v * 0.5; END LOOP; 
    IF (a(a'length-1) = '1') THEN a_adj_v := -pow_int_v;
    ELSE a_adj_v := 0.0; END IF;
    pow_int_v := pow_int_v * 0.5;
    a_tmp_v := 0.0;
    FOR I IN a'length-2 DOWNTO 0 LOOP
      IF a(I) = '1' THEN
        a_tmp_v := a_tmp_v + pow_int_v;
      END IF;
      pow_int_v := pow_int_v * 0.5;
    END LOOP;
    a_tmp_v := a_tmp_v + a_adj_v;
    RETURN a_tmp_v;
  END; -- FUNCTION CORDIC_BEH_slv_to_real;      

  FUNCTION CORDIC_BEH_sbv_to_slv(a:BIT_VECTOR) RETURN STD_LOGIC_VECTOR IS
    VARIABLE slv_v : STD_LOGIC_VECTOR(a'length-1 DOWNTO 0);
  BEGIN
    FOR I IN a'length-1 DOWNTO 0 LOOP
	  slv_v(I) := '0';-- Default Assigment = 'U'
      IF (a(a'low + I) = '1') THEN slv_v(I) := '1'; END IF;
    END LOOP;
    RETURN slv_v;
  END; -- FUNCTION CORDIC_BEH_sbv_to_slv;

  FUNCTION CORDIC_BEH_slv_to_sbv(a:STD_LOGIC_VECTOR) RETURN BIT_VECTOR IS
    VARIABLE sbv_v : BIT_VECTOR(a'length-1 DOWNTO 0);
  BEGIN
    FOR I IN a'length-1 DOWNTO 0 LOOP
	  sbv_v(I) := '0';-- Default Assigment = 'U'
      IF (a(a'low + I) = '1') THEN sbv_v(I) := '1'; END IF;
    END LOOP;
    RETURN sbv_v;
  END; -- FUNCTION CORDIC_BEH_slv_to_sbv;
  
  FUNCTION CORDIC_BEH_max_int(a : IN INTEGER; b : IN INTEGER) RETURN INTEGER IS
    VARIABLE max_v : INTEGER;
  BEGIN
    max_v := a;
    IF b > a THEN max_v := b; END IF;
    RETURN max_v;
  END; --FUNCTION CORDIC_BEH_max_int;
    
  FUNCTION CORDIC_BEH_min_int(a : IN INTEGER; b : IN INTEGER) RETURN INTEGER IS
    VARIABLE min_v : INTEGER;
  BEGIN
    min_v := a;
    IF b < a THEN min_v := b; END IF;
    RETURN min_v;
  END; --FUNCTION CORDIC_BEH_min_int;
  
  FUNCTION CORDIC_BEH_rnd_slv(a : IN STD_LOGIC_VECTOR; mode : IN INTEGER; precision : IN INTEGER) 
       RETURN STD_LOGIC_VECTOR IS
    VARIABLE adj_v : STD_LOGIC_VECTOR(a'length - 1 DOWNTO 0);
    VARIABLE a_int_v : STD_LOGIC_VECTOR(a'length - 1 DOWNTO 0);
    VARIABLE rnd_v : STD_LOGIC_VECTOR(precision - 1 DOWNTO 0);
    
  BEGIN

    IF (a'length <= precision) THEN
      FOR I IN precision-1 DOWNTO 0 LOOP 
        IF ((a'length-I) > 0) THEN 
          rnd_v(precision-1-I) := a(a'length-1-I); 
        ELSE 
          rnd_v(precision-1-I) := '0'; 
        END IF;
      END LOOP;
    ELSE -- (a'length > precision)
      adj_v := (OTHERS => '0');
      IF (mode /= CORDIC_BEH_round_truncate) THEN
        IF ( ((mode = CORDIC_BEH_round_pos_neg_inf) AND (a(a'length-1) = '1')) OR
             ((mode = CORDIC_BEH_round_nearest_even) AND (a(a'length-precision) = '1') AND (a(a'length-1) = '1')) OR
             ((mode = CORDIC_BEH_round_nearest_even) AND (a(a'length-precision) = '0') AND (a(a'length-1) = '0')) ) THEN
          FOR I IN a'length-1 DOWNTO 0 LOOP 
            IF ((a'length-1-precision-I) > 0) THEN adj_v(I) := '1'; END IF;
          END LOOP;
        ELSE
          adj_v(a'length-1-precision) := '1';
        END IF;
      END IF;

      a_int_v := CORDIC_BEH_add_sub_signed_slv(a, adj_v, '1', '0');
      
      FOR I IN precision-1 DOWNTO 0 LOOP rnd_v(precision-1-I) := a_int_v(a'length-1-I); END LOOP;

    END IF;

    RETURN rnd_v;                 

  END; -- FUNCTION CORDIC_BEH_rnd_slv;

  FUNCTION CORDIC_BEH_add_sub_signed_slv(a : STD_LOGIC_VECTOR; b : STD_LOGIC_VECTOR; add_nsub : STD_LOGIC;
                                          c : STD_LOGIC) RETURN STD_LOGIC_VECTOR IS
    CONSTANT c_length_int : INTEGER := CORDIC_BEH_max_int(a'length, b'length);
    VARIABLE a_int_v, b_int_v :STD_LOGIC_VECTOR(c_length_int-1 DOWNTO 0); 
    VARIABLE c_int_v : STD_LOGIC;
    VARIABLE c_out_v : STD_LOGIC;
    VARIABLE a_xor_b_v : STD_LOGIC;
    VARIABLE s_out_v : STD_LOGIC;
    VARIABLE s_int_v : STD_LOGIC_VECTOR(c_length_int-1 DOWNTO 0);
  BEGIN

    c_int_v := c;

    FOR I IN c_length_int-1 DOWNTO 0 LOOP
      a_int_v(I) := a(a'high);
      b_int_v(I) := b(b'high);
      IF (I < a'length) THEN a_int_v(I) := a(a'low + I); END IF;
      IF (I < b'length) THEN b_int_v(I) := b(b'low + I); END IF;
      IF (add_nsub = '0') THEN --Invert b_int
        IF b_int_v(I) = '0' THEN b_int_v(I) := '1'; ELSE b_int_v(I) := '0'; END IF; 
      END IF;
    END LOOP;
          
    FOR I IN 0 TO c_length_int-1 LOOP
      c_out_v := '0';
      IF (((a_int_v(I) = '1') AND (b_int_v(I) = '1')) OR 
          ((a_int_v(I) = '1') AND (c_int_v = '1')) OR
          ((b_int_v(I) = '1') AND (c_int_v = '1'))) THEN
        c_out_v := '1';
      END IF;
      a_xor_b_v := '0';
      IF (((a_int_v(I) = '1') AND (b_int_v(I) = '0')) OR
          ((a_int_v(I) = '0') AND (b_int_v(I) = '1'))) THEN
        a_xor_b_v := '1';
      END IF;
      s_out_v := '0';
      IF (((a_xor_b_v = '1') AND (c_int_v = '0')) OR
          ((a_xor_b_v = '0') AND (c_int_v = '1'))) THEN
        s_out_v := '1';
      END IF;      
      c_int_v := c_out_v;
      s_int_v(I) := s_out_v;
    END LOOP;    
    RETURN s_int_v;    
  END; --FUNCTION CORDIC_BEH_add_sub_signed_slv;
  
  FUNCTION CORDIC_BEH_rshift_slv(a : IN STD_LOGIC_VECTOR; shift : IN INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE rshift_v : STD_LOGIC_VECTOR(a'length-1 DOWNTO 0); 
  BEGIN
    rshift_v := CORDIC_BEH_set_vect_slv(rshift_v, a(a'high));	
    FOR I IN (a'length - shift -2) DOWNTO 0 LOOP
      rshift_v(I) := a(I+shift+a'low);	
    END LOOP;    
    RETURN rshift_v;
  END; --FUNCTION CORDIC_BEH_rshift_slv;
  
  FUNCTION CORDIC_BEH_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER
                            ) RETURN STD_LOGIC_VECTOR IS
    VARIABLE cordic_scale_ext_v: STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0);
    VARIABLE cordic_scale_v: STD_LOGIC_VECTOR(precision_int-1 DOWNTO 0);
  BEGIN
    IF ((cordic_funct /= CORDIC_BEH_f_sinh_cosh ) AND (cordic_funct /= CORDIC_BEH_f_atanh)) THEN 
      FOR I IN CORDIC_BEH_max_rom_width-1 DOWNTO 0 LOOP
        cordic_scale_ext_v(I) := 
          CORDIC_BEH_cordic_scale_trig_const_slv(CORDIC_BEH_max_rom_width * (iterations_int-1) +I);
      END LOOP;    
    ELSE -- Hyperbolic
      FOR I IN precision_int-1 DOWNTO 0 LOOP
        cordic_scale_ext_v(I) := 
          CORDIC_BEH_cordic_scale_hyp_const_slv(CORDIC_BEH_max_rom_width * (iterations_int-1) +I);
      END LOOP;    
    END IF;
    cordic_scale_v := CORDIC_BEH_rnd_slv(cordic_scale_ext_v, 3, precision_int);
    RETURN cordic_scale_v;
  END; --FUNCTION CORDIC_BEH_cordic_scale_slv;

  FUNCTION CORDIC_BEH_inv_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE inv_cordic_scale_ext_v: STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0);
    VARIABLE inv_cordic_scale_v: STD_LOGIC_VECTOR(precision_int-1 DOWNTO 0);
  BEGIN
    IF ((cordic_funct /= CORDIC_BEH_f_sinh_cosh ) AND (cordic_funct /= CORDIC_BEH_f_atanh)) THEN 
      FOR I IN CORDIC_BEH_max_rom_width-1 DOWNTO 0 LOOP
        inv_cordic_scale_ext_v(I) := 
          CORDIC_BEH_inv_cordic_scale_trig_const_slv(CORDIC_BEH_max_rom_width * (iterations_int-1) +I);
      END LOOP;    
    ELSE -- Hyperbolic
      FOR I IN CORDIC_BEH_max_rom_width-1 DOWNTO 0 LOOP
        inv_cordic_scale_ext_v(I) := 
          CORDIC_BEH_inv_cordic_scale_hyp_const_slv(CORDIC_BEH_max_rom_width * (iterations_int-1) +I);
      END LOOP;    
    END IF;
    inv_cordic_scale_v := CORDIC_BEH_rnd_slv(inv_cordic_scale_ext_v, 3, precision_int);
    RETURN inv_cordic_scale_v;
  END; --FUNCTION CORDIC_BEH_inv_cordic_scale_slv;
 

  FUNCTION CORDIC_BEH_inv_cordic_scale_str(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STRING IS
    VARIABLE inv_scale_v : STRING(1 TO precision_int);
  BEGIN
    inv_scale_v := CORDIC_BEH_slv_to_str(CORDIC_BEH_inv_cordic_scale_slv(cordic_funct,iterations_int,precision_int));
  	RETURN inv_scale_v;
  END; --FUNCTION CORDIC_BEH_inv_cordic_scale_str;
  
END; -- PACKAGE BODY cordic_pack_beh;

-------------------------------------------------------------------------------------
-- CORDIC V3_0 BODY
-------------------------------------------------------------------------------------
LIBRARY IEEE;
LIBRARY XilinxCoreLib;

USE IEEE.std_logic_1164.ALL;

--LIBRARY bhv_vhdl;
--USE bhv_vhdl.cordic_pack_beh.ALL;
USE XilinxCoreLib.cordic_pack_beh.ALL;

USE XilinxCoreLib.prims_constants_V7_0.ALL;

--USE ieee.std_logic_signed.ALL;
USE XilinxCoreLib.iputils_std_logic_signed.ALL;
                       
ARCHITECTURE behavioral OF cordic_v3_0 IS

  CONSTANT behav_reg_delay : TIME := 2 ns;

  CONSTANT c_iterations_int : INTEGER := CORDIC_BEH_get_iterations_int(c_coarse_rotate, c_cordic_function, 
             c_iterations, c_output_width, c_round_mode);

  CONSTANT c_precision_int : INTEGER := CORDIC_BEH_get_precision_int(c_cordic_function, c_data_format,
             c_input_width, c_iterations_int, c_output_width, c_precision, c_round_mode);

  CONSTANT c_scale_comp_int : INTEGER := CORDIC_BEH_get_scale_comp_int(c_family, c_scale_comp);

  FUNCTION check_generics RETURN BOOLEAN IS
    VARIABLE status_int : BOOLEAN;
  BEGIN
    status_int := TRUE;
    -- function-architecture checks
    IF(c_architecture = CORDIC_BEH_wser_arch and c_cordic_function = CORDIC_BEH_f_sqrt) THEN
       ASSERT FALSE 
          REPORT "CORDIC: WSER architecture not avaliable for SQRT Function" &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- architecture-pipeline checks
    IF((c_architecture = CORDIC_BEH_wser_arch) and (c_pipeline_mode = CORDIC_BEH_pipe_none)) THEN
       ASSERT FALSE 
          REPORT "CORDIC: C_PIPE_NONE is an invalid option for WSER architecture" &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- function-scale_compensation checks
    IF( ( (c_cordic_function = CORDIC_BEH_f_sin_cos) OR (c_cordic_function = CORDIC_BEH_f_sinh_cosh) OR
          (c_cordic_function = CORDIC_BEH_f_atan) OR (c_cordic_function = CORDIC_BEH_f_atanh) OR
          (c_cordic_function = CORDIC_BEH_f_sqrt) ) AND (c_scale_comp /= CORDIC_BEH_scale_none) ) THEN
       ASSERT FALSE 
          REPORT "CORDIC: Scaling is not required for selected Function" &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- input width check
    IF( c_input_width < 8 OR c_input_width > 64) THEN
       ASSERT FALSE 
          REPORT "CORDIC: Input width must be between 8 and 64 " &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- output width check
    IF( c_output_width < 8 OR c_output_width > 64) THEN
       ASSERT FALSE 
          REPORT "CORDIC: Output width must be between 8 and 64 " &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- iterations check
    IF( c_iterations_int < 0 OR c_iterations_int > c_output_width) THEN
       ASSERT FALSE 
          REPORT "CORDIC: Iterations must be in the range {0 to Output Width} " &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- precision check
    IF( c_precision_int < c_output_width) THEN
       ASSERT FALSE 
          REPORT "CORDIC: precision must be greater than or equal to Output Width " &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    -- input port check
    IF(( c_has_x_in /= CORDIC_BEH_funct_has_port(c_cordic_function,5)) OR
       ( c_has_y_in /= CORDIC_BEH_funct_has_port(c_cordic_function,4)) OR
       ( c_has_phase_in /= CORDIC_BEH_funct_has_port(c_cordic_function,3)) ) THEN
       ASSERT FALSE 
          REPORT "CORDIC: Input ports are inconsistent with Functional Configuration " &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;
    
    -- check input data_format
    IF(( c_data_format = CORDIC_BEH_format_sig_frac AND c_cordic_function = CORDIC_BEH_f_sqrt) OR
       ( c_data_format = CORDIC_BEH_format_usig_frac AND c_cordic_function /= CORDIC_BEH_f_sqrt) OR
       ( c_data_format = CORDIC_BEH_format_usig_int AND c_cordic_function /= CORDIC_BEH_f_sqrt) ) THEN
       ASSERT FALSE 
          REPORT "CORDIC: Data format is inconsistent with Functional Configuration " &
          CORDIC_BEH_new_line
          SEVERITY ERROR;
    END IF;

    RETURN status_int;
  END; -- FUNCTION check_generics;

  CONSTANT c_ctrl_width : INTEGER := CORDIC_BEH_gen_ctrl_width(c_coarse_rotate);
  
  CONSTANT c_inv_scale : STD_LOGIC_VECTOR := 
    CORDIC_BEH_inv_cordic_scale_slv(c_cordic_function,c_iterations_int,c_precision_int);
  SIGNAL s_inv_scale : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := 
    CORDIC_BEH_inv_cordic_scale_slv(c_cordic_function,c_iterations_int,c_precision_int);

  -- Functions for input Configuration Stage.
  FUNCTION f_get_inp_data_latency(architecture_sel:INTEGER; nd_latency:INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := nd_latency;
    IF (architecture_sel = CORDIC_BEH_wser_arch) THEN
      latency_v := nd_latency + 2;
    END IF;
    RETURN latency_v;
  END; -- FUNCTION f_get_inp_data_latency;

  CONSTANT c_inp_nd_latency : INTEGER := CORDIC_BEH_get_inp_config_latency(c_architecture, c_coarse_rotate, 
                                           c_cordic_function, c_pipeline_mode, c_reg_inputs);
  CONSTANT c_inp_data_latency : INTEGER := f_get_inp_data_latency(c_architecture, c_inp_nd_latency);

  CONSTANT c_neg_pi_int_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
             CORDIC_BEH_select_slv_int(CORDIC_BEH_neg_pi_rads_const,CORDIC_BEH_neg_pi_jrads_const, c_phase_format); 
  CONSTANT c_neg_pi_const : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := 
             c_neg_pi_int_const(CORDIC_BEH_max_rom_width-1 DOWNTO CORDIC_BEH_max_rom_width-c_precision_int);
  CONSTANT c_neg_pi_3_4_int_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
             CORDIC_BEH_select_slv_int(CORDIC_BEH_neg_pi_3_4_rads_const,CORDIC_BEH_neg_pi_3_4_jrads_const, c_phase_format); 
  CONSTANT c_neg_pi_3_4_const : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := 
             c_neg_pi_3_4_int_const(CORDIC_BEH_max_rom_width-1 DOWNTO CORDIC_BEH_max_rom_width-c_precision_int);
  CONSTANT c_neg_pi_2_4_int_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
             CORDIC_BEH_select_slv_int(CORDIC_BEH_neg_pi_2_4_rads_const,CORDIC_BEH_neg_pi_2_4_jrads_const, c_phase_format); 
  CONSTANT c_neg_pi_2_4_const : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := 
             c_neg_pi_2_4_int_const(CORDIC_BEH_max_rom_width-1 DOWNTO CORDIC_BEH_max_rom_width-c_precision_int);
  CONSTANT c_neg_pi_1_4_int_const : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width-1 DOWNTO 0) :=
             CORDIC_BEH_select_slv_int(CORDIC_BEH_neg_pi_1_4_rads_const,CORDIC_BEH_neg_pi_1_4_jrads_const, c_phase_format); 
  CONSTANT c_neg_pi_1_4_const : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := 
             c_neg_pi_1_4_int_const(CORDIC_BEH_max_rom_width-1 DOWNTO CORDIC_BEH_max_rom_width-c_precision_int);

  --Functions, Types and Constants for the Cordic Engine
  SUBTYPE eng_data_type IS STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
  TYPE	eng_data_vect IS ARRAY (c_iterations_int DOWNTO 0) of eng_data_type;
  SUBTYPE eng_control_type IS STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0); 
  TYPE eng_control_vect IS ARRAY (c_iterations_int DOWNTO 0) OF eng_control_type; 
  TYPE eng_add_nsub_vect_type IS ARRAY (c_iterations_int DOWNTO 0) OF STD_LOGIC_VECTOR(2 DOWNTO 0);

  CONSTANT c_eng_mode : STD_LOGIC := CORDIC_BEH_get_eng_mode(c_cordic_function);
  CONSTANT c_transform_type : INTEGER := CORDIC_BEH_get_transform_type(c_cordic_function);
  FUNCTION f_select_rom_source(cordic_function: INTEGER; phase_format : INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE atan_rom_source_v : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0);
  BEGIN
    atan_rom_source_v := (OTHERS=>'0');
    IF ( ((cordic_function /= CORDIC_BEH_f_sinh_cosh) AND (cordic_function /= CORDIC_BEH_f_atanh)) AND
         (c_phase_format = CORDIC_BEH_format_rad) ) THEN atan_rom_source_v := CORDIC_BEH_atan_rads; END IF;
    IF ( ((cordic_function /= CORDIC_BEH_f_sinh_cosh) AND (cordic_function /= CORDIC_BEH_f_atanh)) AND
         (c_phase_format = CORDIC_BEH_format_sca) ) THEN atan_rom_source_v := CORDIC_BEH_atan_jrads; END IF;
    IF ( ((cordic_function = CORDIC_BEH_f_sinh_cosh) OR (cordic_function = CORDIC_BEH_f_atanh)) AND
         (c_phase_format = CORDIC_BEH_format_rad) ) THEN atan_rom_source_v := CORDIC_BEH_atanh_rads; END IF;
    IF ( ((cordic_function = CORDIC_BEH_f_sinh_cosh) OR (cordic_function = CORDIC_BEH_f_atanh)) AND
         (c_phase_format = CORDIC_BEH_format_sca) ) THEN atan_rom_source_v := CORDIC_BEH_atanh_jrads; END IF;
    RETURN atan_rom_source_v;
  END; -- FUNCTION f_select_rom_source
  CONSTANT c_atan_rom_source : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width*CORDIC_BEH_max_rom_length-1 DOWNTO 0) := 
             f_select_rom_source(c_cordic_function,c_phase_format);

  FUNCTION f_rom_data_int(iterations_int:INTEGER;precision_int:INTEGER) RETURN eng_data_vect IS
    VARIABLE atan_rom_slice_v : STD_LOGIC_VECTOR(CORDIC_BEH_max_rom_width -1 DOWNTO 0);
    VARIABLE rom_data_v : eng_data_vect;
  BEGIN
    FOR I IN 0 TO iterations_int-1 LOOP
      atan_rom_slice_v := c_atan_rom_source((I+1) * CORDIC_BEH_max_rom_width -1 DOWNTO I * CORDIC_BEH_max_rom_width);
      rom_data_v(I) := CORDIC_BEH_rnd_slv(atan_rom_slice_v,CORDIC_BEH_round_nearest_even,precision_int);      
    END LOOP;
    RETURN rom_data_v;
  END;
  CONSTANT eng_rom_vect : eng_data_vect := f_rom_data_int(c_iterations_int,c_precision_int);
  
  CONSTANT c_eng_nd_latency   : INTEGER := CORDIC_BEH_get_engine_latency(c_architecture, c_iterations_int, c_pipeline_mode);
  CONSTANT c_eng_data_latency : INTEGER := CORDIC_BEH_get_engine_latency(c_architecture, c_iterations_int, c_pipeline_mode);
  
  --Output Configuration Functions, Constants
  FUNCTION f_get_outp_data_latency(architecture_sel:INTEGER; nd_latency:INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := nd_latency;
    IF (architecture_sel = CORDIC_BEH_wser_arch) THEN
      latency_v := nd_latency - 2;
    END IF;
    RETURN latency_v;
  END; -- FUNCTION f_get_outp_data_latency;

  CONSTANT c_outp_nd_latency : INTEGER := CORDIC_BEH_get_out_config_latency(c_architecture, c_coarse_rotate,
                                            c_cordic_function, c_iterations_int, c_pipeline_mode, c_precision_int, 
                                            c_reg_outputs, c_round_mode, c_scale_comp_int);

  CONSTANT c_outp_data_latency : INTEGER := f_get_outp_data_latency(c_architecture, c_outp_nd_latency);

  --SQRT FUNCTIONS
  CONSTANT c_rnd_mode_int : INTEGER := CORDIC_BEH_get_rnd_mode_int(c_cordic_function, c_round_mode);

  -- Note this function includes the input register stage unlike struct model.
  FUNCTION get_sqrt_data_latency(data_format:INTEGER;input_width:INTEGER;output_width:INTEGER;pipeline_mode:INTEGER;
             precision:INTEGER;reg_inputs:INTEGER;reg_outputs:INTEGER;round_mode:INTEGER) RETURN INTEGER IS
    VARIABLE latency_sqrt_v : INTEGER; 
    VARIABLE latency_v : INTEGER; 
  BEGIN
    latency_sqrt_v := CORDIC_BEH_get_sqrt_latency(data_format,input_width,output_width,pipeline_mode,precision,
                     reg_inputs,reg_outputs,round_mode) - 1;
    latency_v := CORDIC_BEH_max_int(0,latency_sqrt_v);
    RETURN latency_v;
  END;
  CONSTANT c_sqrt_data_latency : INTEGER := get_sqrt_data_latency(c_data_format,c_input_width,c_output_width,
             c_pipeline_mode,c_precision_int,c_reg_inputs,c_reg_outputs,c_round_mode);

  FUNCTION sqrt_slv(data_in : IN STD_LOGIC_VECTOR; precision_int : IN INTEGER; data_format : IN INTEGER) 
           RETURN STD_LOGIC_VECTOR IS
    CONSTANT data_width_even : INTEGER := data_in'length + (data_in'length MOD 2);
    VARIABLE data_even : STD_LOGIC_VECTOR(data_width_even-1 DOWNTO 0);
    VARIABLE data_int : STD_LOGIC_VECTOR(2*precision_int-1 DOWNTO 0);
    VARIABLE rem_int : STD_LOGIC_VECTOR(2*precision_int-1 DOWNTO 0);
    VARIABLE rem_next : STD_LOGIC_VECTOR(2*precision_int-1 DOWNTO 0);
    VARIABLE sqre_diff : STD_LOGIC_VECTOR(2*precision_int-1 DOWNTO 0);
    VARIABLE sqrt_int : STD_LOGIC_VECTOR(precision_int-1 DOWNTO 0);    
  BEGIN

    IF (data_format = CORDIC_BEH_format_usig_int) THEN
      FOR I IN 0 TO (2*precision_int-1) LOOP
        IF (I <= (1-(data_in'length MOD 2))) THEN
          data_int(2*precision_int-1 -I) := '0';
        ELSIF (I <= data_in'length+(1-(data_in'length MOD 2))) THEN
          data_int(2*precision_int-1 -I) := data_in(data_in'length-1-I+2-(data_in'length MOD 2));
        ELSE
          data_int(2*precision_int-1 -I) := '0';
        END IF;
      END LOOP;
    END IF;
    
    IF (data_format = CORDIC_BEH_format_usig_frac) THEN
      FOR I IN 0 TO (2*precision_int-1)  LOOP
        IF (I = 0) THEN
          data_int(2*precision_int-1 -I) := '0';
        ELSIF (I <= c_input_width) THEN
          data_int(2*precision_int-1 -I) := data_in(data_in'length-I);
        ELSE
          data_int(2*precision_int-1 -I) := '0';
        END IF;
      END LOOP;
    END IF;    

    --init variables    
    sqre_diff := (OTHERS=>'0');
    sqre_diff(1) := '0';
    sqre_diff(0) := '1';
    rem_int := (OTHERS=>'0');
    rem_next := (OTHERS=>'0');
    sqrt_int := (OTHERS=>'0');

    FOR I IN precision_int-1 DOWNTO 0 LOOP
      --left shift the existing remainder internal
      FOR J IN precision_int-2 DOWNTO 0 LOOP
        rem_int(J+2) := rem_int(J);
      END LOOP;
      rem_int(1) := data_int (2*I+1);
      rem_int(0) := data_int (2*I);
      --update the current difference in the Square Difference
      FOR J IN precision_int-3 DOWNTO 0 LOOP
        sqre_diff(J+2) := sqrt_int(J);
      END LOOP;
      rem_next := rem_int - sqre_diff;
      --assign sqrt_int
      FOR J IN precision_int-2 DOWNTO 0 LOOP
        sqrt_int(J+1) := sqrt_int(J);
      END LOOP;
      sqrt_int(0) := '0';
      IF (rem_next(precision_int) = '0') THEN
        rem_int := rem_next;
        sqrt_int(0) := '1';
      END IF;
    END LOOP;
    RETURN sqrt_int;

  END; -- FUNCTION;
  
  --Global signals
  SIGNAL aclr_int : STD_LOGIC := '0';
  SIGNAL ce_int : STD_LOGIC := '1';
  SIGNAL sclr_int : STD_LOGIC := '0';
  SIGNAL nd_int : STD_LOGIC := '1';
  SIGNAL data_x_int : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_y_int : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL phase_int : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0)  := (OTHERS => '0');
  SIGNAL data_x_init : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_y_init : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL phase_init : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');

  SIGNAL inp_x_min_y : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_x_plus_y : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_data_sign_vect : STD_LOGIC_VECTOR(3 DOWNTO 0) := (OTHERS => '0');

  SIGNAL data_x_init_ext : STD_LOGIC_VECTOR(c_precision_int DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_y_init_ext : STD_LOGIC_VECTOR(c_precision_int DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_x_min_y_ext : STD_LOGIC_VECTOR(c_precision_int DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_x_plus_y_ext : STD_LOGIC_VECTOR(c_precision_int DOWNTO 0) := (OTHERS => '0');

  SIGNAL inp_data_x_cr_async : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_data_y_cr_async : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_phase_cr_async : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_data_quad : STD_LOGIC_VECTOR(1 DOWNTO 0) := (OTHERS => '1');
  SIGNAL inp_phase_sign_vect : STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_phase_pi_3_rot : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_phase_pi_1_rot : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_phase_quad : STD_LOGIC_VECTOR(1 DOWNTO 0) := (OTHERS => '1');
  SIGNAL inp_phase_data_quad : STD_LOGIC_VECTOR(3 DOWNTO 0) := (OTHERS => '1');
  SIGNAL inp_ctrl_cr_async : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');

  SIGNAL inp_data_x_cr : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_data_y_cr : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_phase_cr  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_ctrl_cr   : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');
 
  SIGNAL inp_data_x_fifo : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_data_y_fifo : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_phase_fifo  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL inp_ctrl_fifo   : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');
    
  SIGNAL data_x_inp : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_y_inp : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL phase_inp  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL ctrl_inp   : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');

  --Cordic Engine Signals
  SIGNAL eng_rfd_async : STD_LOGIC := '1';

  SIGNAL eng_data_x_async : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_data_y_async : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_phase_async  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_ctrl_async   : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');

  SIGNAL eng_data_x_fifo : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_data_y_fifo : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_phase_fifo  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_ctrl_fifo   : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL eng_rdy : STD_LOGIC := '0';
  SIGNAL eng_nd_reg : STD_LOGIC := '0';
  SIGNAL eng_rfd_reg : STD_LOGIC := '0';

  SIGNAL data_x_eng : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_y_eng : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL phase_eng  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL ctrl_eng   : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL rfd_eng : STD_LOGIC := '1';

  --Output Config Signals
  SIGNAL outp_data_x_cr : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_y_cr : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_phase_cr  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_cr_quad  : STD_LOGIC_VECTOR(2-1 DOWNTO 0) := (OTHERS => '1');

  SIGNAL outp_data_x_sca : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_y_sca : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_phase_sca  : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_x_sca_ext : STD_LOGIC_VECTOR(2*c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_y_sca_ext : STD_LOGIC_VECTOR(2*c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_phase_sca_ext  : STD_LOGIC_VECTOR(2*c_precision_int-1 DOWNTO 0) := (OTHERS => '0');

  SIGNAL outp_data_x_rnd : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_y_rnd : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_phase_rnd  : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_rdy_rnd : STD_LOGIC := '0';

  SIGNAL outp_data_x_fifo : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_y_fifo : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_phase_fifo  : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_rdy_fifo : STD_LOGIC := '0';

  SIGNAL outp_data_x_reg : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_data_y_reg : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_phase_reg  : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL outp_rdy_reg :STD_LOGIC := '0';

  SIGNAL outp_ce_and_rdy :STD_LOGIC := '0';
  
  SIGNAL data_x_outp :STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_y_outp :STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL phase_outp :STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL rdy_outp : STD_LOGIC := '0';
  SIGNAL rfd_outp : STD_LOGIC := '1';
  
  --SQRT signals
  SIGNAL sqrt_data_trunc_async : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL sqrt_data_trunc_async_ext : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL sqrt_data_round_async : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL sqrt_data_fifo : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL data_x_sqrt : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL sqrt_nd_fifo : STD_LOGIC := '0';
  SIGNAL sqrt_rdy_int : STD_LOGIC := '0';
  SIGNAL sqrt_ce_and_rdy : STD_LOGIC := '0';
  SIGNAL rdy_sqrt : STD_LOGIC := '0';
  SIGNAL sqrt_data_reg : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
  SIGNAL sqrt_rdy_reg : STD_LOGIC := '0';
  
BEGIN

    gs0 : IF (c_has_aclr = 0) GENERATE
      aclr_int <= '0';
    END GENERATE;
    gs1 : IF (c_has_aclr = 1) GENERATE
      aclr_int <= aclr;
    END GENERATE;
  
    gs2 : IF (c_has_ce = 0) GENERATE
      ce_int <= '1';
    END GENERATE;
    gs3 : IF (c_has_ce = 1) GENERATE
      ce_int <= ce;
    END GENERATE;
  
    gs4 : IF (c_has_nd = 0) GENERATE
      nd_int <= '1';
    END GENERATE;
    gs5 : IF (c_has_nd = 1) GENERATE
      nd_int <= nd;
    END GENERATE;
  
    gs6 : IF (c_has_sclr = 0) GENERATE
      sclr_int <= '0';
    END GENERATE;
    gs7 : IF (c_has_sclr = 1) GENERATE
      sclr_int <= sclr;
    END GENERATE;
    
    --Extend truncate/extend input data as required.
    gs8 : FOR I IN 0 TO c_precision_int-1 GENERATE
      gs9: IF (c_input_width -1 - I >= 0) GENERATE
        data_x_int(c_precision_int - 1 - I) <= x_in(x_in'high - I);
        data_y_int(c_precision_int - 1 - I) <= y_in(y_in'high - I);
        phase_int(c_precision_int - 1 - I) <= phase_in(phase_in'high - I);
      END GENERATE;
      gs10: IF (c_input_width -1 - I < 0) GENERATE
        data_x_int(c_precision_int - 1 - I) <= '0';
        data_y_int(c_precision_int - 1 - I) <= '0';
        phase_int(c_precision_int - 1 - I) <= '0';
      END GENERATE;
    END GENERATE;
  
    --Set up initial conditions for selected functional configuration.
    gs11_rotate : IF (c_cordic_function = CORDIC_BEH_f_rotate) GENERATE
      data_x_init <= data_x_int;
      data_y_init <= data_y_int;
      phase_init <= phase_int;
    END GENERATE;
    gs11_translate : IF (c_cordic_function = CORDIC_BEH_f_translate) GENERATE
      data_x_init <= data_x_int;
      data_y_init <= data_y_int;
      phase_init <= (OTHERS => '0');
    END GENERATE;
    gs11_sin_cos : IF ((c_cordic_function = CORDIC_BEH_f_sin_cos) OR
                       (c_cordic_function = CORDIC_BEH_f_sinh_cosh)) GENERATE
      data_x_init <= c_inv_scale;
      data_y_init <= (OTHERS => '0');
      phase_init <= phase_int;
    END GENERATE;
    gs11_atan : IF ((c_cordic_function = CORDIC_BEH_f_atan) OR
                    (c_cordic_function = CORDIC_BEH_f_atanh)) GENERATE
      data_x_init <= data_x_int;
      data_y_init <= data_y_int;
      phase_init <= (OTHERS => '0');
    END GENERATE;
    gs11_sqrt : IF (c_cordic_function = CORDIC_BEH_f_sqrt) GENERATE
      data_x_init <= data_x_int;
      data_y_init <= (OTHERS => '0');
      phase_init <= (OTHERS => '0');
    END GENERATE;

    ---------------------------------------------------------------------------------------------
    --Instantiate CORDIC ENGINE
    gicor: IF (c_cordic_function /= CORDIC_BEH_f_sqrt) GENERATE
      ---------------------------------------------------------------------------------------------
      -- Implement Input Configuration Stage

      -- Generate Coarse Rotate
      gcr1: IF (c_coarse_rotate = 1) GENERATE

        data_x_init_ext <= (data_x_init(c_precision_int-1) & data_x_init);
        data_y_init_ext <= (data_y_init(c_precision_int-1) & data_y_init);
        -- Gen control for Data Coarse Rotate
        inp_x_min_y_ext <= data_x_init_ext - data_y_init_ext;
        inp_x_plus_y_ext <= data_x_init_ext + data_y_init_ext;
        inp_data_sign_vect <= (inp_x_min_y_ext(c_precision_int) & inp_x_plus_y_ext(c_precision_int) &
                           data_x_init_ext(c_precision_int) & data_y_init_ext(c_precision_int));
    
        -- Coarse Rotation of Data Vector
        rotate_xy_data : PROCESS(data_x_init,data_y_init,inp_data_sign_vect)
        BEGIN
          CASE inp_data_sign_vect IS
      	    WHEN "0000"|"0001" => 
              inp_data_x_cr_async <= data_x_init;
              inp_data_y_cr_async <= data_y_init;
              inp_data_quad <= "11";
      	    WHEN "1000"|"1010" => 
              inp_data_x_cr_async <= data_y_init;
              inp_data_y_cr_async <= - data_x_init;
              inp_data_quad <= "01";
      	    WHEN "1110"|"1111" => 
              inp_data_x_cr_async <= - data_x_init;
              inp_data_y_cr_async <= - data_y_init;
              inp_data_quad <= "00";
      	    WHEN "0111"|"0101" => 
              inp_data_x_cr_async <= - data_y_init;
              inp_data_y_cr_async <= data_x_init;
              inp_data_quad <= "10";
            WHEN OTHERS =>
              inp_data_x_cr_async <= (OTHERS=> 'X');
              inp_data_y_cr_async <= (OTHERS=> 'X');
              inp_data_quad <= "XX";
          END CASE;
        END PROCESS;
    
        -- Gen Control for Coarse Rotation of Input Phase
        inp_phase_sign_vect(2) <= phase_init(c_precision_int-1);
        inp_phase_sign_vect(1) <= inp_phase_pi_3_rot(c_precision_int -1);
        inp_phase_sign_vect(0) <= inp_phase_pi_1_rot(c_precision_int -1);

        gen_phase_pi_sigs : PROCESS(phase_init, inp_phase_sign_vect(2)) 
        BEGIN
          inp_phase_pi_3_rot <= phase_init - c_neg_pi_3_4_const;
          inp_phase_pi_1_rot <= phase_init - c_neg_pi_1_4_const;
          IF (inp_phase_sign_vect(2) = '0') THEN
            inp_phase_pi_3_rot <= phase_init + c_neg_pi_3_4_const;
            inp_phase_pi_1_rot <= phase_init + c_neg_pi_1_4_const;
          END IF;
        END PROCESS;
    
        -- Coarse Rotation of Input Phase Vector
        rotate_p_data : PROCESS(phase_init,inp_phase_sign_vect)
        BEGIN
          CASE inp_phase_sign_vect IS
      	    WHEN "011" => 
              inp_phase_cr_async <= phase_init;
              inp_phase_quad <= "11";
      	    WHEN "010" => 
              inp_phase_cr_async <= phase_init + c_neg_pi_2_4_const;
              inp_phase_quad <= "01";
      	    WHEN "000" => 
              inp_phase_cr_async <= phase_init + c_neg_pi_const;
              inp_phase_quad <= "00";
      	    WHEN "100" => 
              inp_phase_cr_async <= phase_init;
              inp_phase_quad <= "11";
      	    WHEN "101" => 
              inp_phase_cr_async <= phase_init - c_neg_pi_2_4_const;
              inp_phase_quad <= "10";
      	    WHEN "111" => 
              inp_phase_cr_async <= phase_init - c_neg_pi_const;
              inp_phase_quad <= "00";
            WHEN OTHERS =>
              inp_phase_cr_async <= (OTHERS => 'X');
              inp_phase_quad <= "XX";
          END CASE;
        END PROCESS;
    
        -- Combine Coarse Rotation from Phase and Data Inputs
        inp_phase_data_quad(3) <= inp_phase_quad(1);
        inp_phase_data_quad(2) <= inp_phase_quad(0);
        inp_phase_data_quad(1) <= inp_data_quad(1);
        inp_phase_data_quad(0) <= inp_data_quad(0);

        combine_phase_data_quad : PROCESS(inp_phase_data_quad)
        BEGIN
          CASE inp_phase_data_quad IS
      	    WHEN "0000"|"0110"|"1001"|"1111" => 
              inp_ctrl_cr_async(2) <= '1';
              inp_ctrl_cr_async(1) <= '1';
      	    WHEN "0001"|"0100"|"1011"|"1110" => 
              inp_ctrl_cr_async(2) <= '1';
              inp_ctrl_cr_async(1) <= '0';
      	    WHEN "0011"|"0101"|"1010"|"1100" => 
              inp_ctrl_cr_async(2) <= '0';
              inp_ctrl_cr_async(1) <= '0';
      	    WHEN "0010"|"0111"|"1000"|"1101" => 
              inp_ctrl_cr_async(2) <= '0';
              inp_ctrl_cr_async(1) <= '1';
            WHEN OTHERS =>
              inp_ctrl_cr_async(2) <= 'X';
              inp_ctrl_cr_async(1) <= 'X';
          END CASE;
        END PROCESS;

        inp_ctrl_cr_async(0) <= nd_int;

      END GENERATE; --IF (p_coarse_rotate = 1) GENERATE
        
      --Select between coarse rotate pass through input data.
      inp_data_x_cr <= data_x_init WHEN (c_coarse_rotate = 0) ELSE inp_data_x_cr_async;  
      inp_data_y_cr <= data_y_init WHEN (c_coarse_rotate = 0) ELSE inp_data_y_cr_async;  
      inp_phase_cr  <= phase_init  WHEN (c_coarse_rotate = 0) ELSE inp_phase_cr_async;  
      gen_inp_ctrl_cr : PROCESS(nd_int, inp_ctrl_cr_async)
      BEGIN
  	    IF (c_coarse_rotate = 1) THEN inp_ctrl_cr <= inp_ctrl_cr_async;
        ELSE inp_ctrl_cr <= (OTHERS => '0'); inp_ctrl_cr(0) <= nd_int; END IF;
      END PROCESS;
      
      --Delay for Input Config Stage
      inst_data_delay : PROCESS(inp_data_x_cr,inp_data_y_cr,inp_phase_cr,inp_ctrl_cr,clk,aclr_int)
        CONSTANT c_inp_latency : INTEGER := CORDIC_BEH_max_int(c_inp_data_latency,c_inp_nd_latency);
        TYPE inp_data_int_type IS ARRAY(c_inp_latency DOWNTO 0) OF STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        TYPE inp_ctrl_int_type IS ARRAY(c_inp_latency DOWNTO 0) OF STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0);
        VARIABLE data_x_int_v : inp_data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE data_y_int_v : inp_data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE phase_int_v : inp_data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE ctrl_int_v : inp_ctrl_int_type := (OTHERS => (OTHERS => '0'));
      BEGIN
        data_x_int_v(0) := inp_data_x_cr;
        data_y_int_v(0) := inp_data_y_cr;
        phase_int_v(0)  := inp_phase_cr;
        ctrl_int_v(0)   := inp_ctrl_cr;
        IF (aclr_int = '1') THEN
          FOR I IN c_inp_latency DOWNTO 1 LOOP
            data_x_int_v(I) := (OTHERS => '0');
            data_y_int_v(I) := (OTHERS => '0');
            phase_int_v(I)  := (OTHERS => '0');
            ctrl_int_v(I)   := (OTHERS => '0');
          END LOOP;
        ELSIF (clk'event AND clk = '1') THEN
          IF (ce_int = '1') THEN
            FOR I IN c_inp_latency DOWNTO 1 LOOP
              data_x_int_v(I) := data_x_int_v(I-1);
              data_y_int_v(I) := data_y_int_v(I-1);
              phase_int_v(I)  := phase_int_v(I-1);
              ctrl_int_v(I)   := ctrl_int_v(I-1);
            END LOOP;
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (ce = '1')) ) THEN
            FOR I IN c_inp_latency DOWNTO 1 LOOP
              data_x_int_v(I) := (OTHERS => '0');
              data_y_int_v(I) := (OTHERS => '0');
              phase_int_v(I)  := (OTHERS => '0');
              ctrl_int_v(I)   := (OTHERS => '0');
            END LOOP;
          END IF;      
        END IF;
        inp_data_x_fifo <= data_x_int_v(c_inp_data_latency) AFTER behav_reg_delay;
        inp_data_y_fifo <= data_y_int_v(c_inp_data_latency)AFTER behav_reg_delay;
        inp_phase_fifo <= phase_int_v(c_inp_data_latency)AFTER behav_reg_delay;
        inp_ctrl_fifo(0) <= ctrl_int_v(c_inp_nd_latency)(0)AFTER behav_reg_delay;
        IF (c_ctrl_width > 1) THEN
          inp_ctrl_fifo(c_ctrl_width-1 DOWNTO 1) <= ctrl_int_v(c_inp_data_latency)(c_ctrl_width-1 DOWNTO 1) AFTER behav_reg_delay;
        END IF;
      END PROCESS;--inst_data_delay
    
      --Output from Input Configuaration Stage.
      data_x_inp <= inp_data_x_fifo; 
      data_y_inp <= inp_data_y_fifo; 
      phase_inp  <= inp_phase_fifo;  
      ctrl_inp   <= inp_ctrl_fifo;

      ---------------------------------------------------------------------------------------------
      -- Implement CORDIC engine stage
      gen_eng : PROCESS(data_x_inp,data_y_inp,phase_inp,ctrl_inp,nd_int,eng_rfd_async,eng_rfd_reg,eng_nd_reg,eng_rdy)
        VARIABLE data_x_int_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE data_y_int_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE phase_int_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE ctrl_int_v : STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0);
        VARIABLE data_x_hw_shift_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE data_y_hw_shift_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE data_x_add_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE data_y_add_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE phase_add_v : STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        VARIABLE add_nsub_x_int_v : STD_LOGIC;
        VARIABLE add_nsub_y_int_v : STD_LOGIC;
        VARIABLE add_nsub_p_int_v : STD_LOGIC;
        VARIABLE transform_type_v : STD_LOGIC := CORDIC_BEH_int_to_sl(c_transform_type);
        VARIABLE I_int_v : INTEGER;
      BEGIN
    
        data_x_int_v := data_x_inp;
        data_y_int_v := data_y_inp;
        phase_int_v  := phase_inp;
        ctrl_int_v   := ctrl_inp;

        add_nsub_x_int_v := 
          ( ( ( ( (c_eng_mode) AND (data_y_int_v(c_precision_int-1)) ) OR
                ( (NOT c_eng_mode) AND (NOT phase_int_v(c_precision_int-1)) )
              ) AND transform_type_v ) OR
            ( ( ( (c_eng_mode) AND (NOT data_y_int_v(c_precision_int-1)) ) OR
                ( (NOT c_eng_mode) AND (phase_int_v(c_precision_int-1)) )   
              ) AND (NOT transform_type_v) )
          );
        add_nsub_y_int_v := 
            ( ( (c_eng_mode) AND (data_y_int_v(c_precision_int-1)) ) OR
              ( (NOT c_eng_mode) AND (NOT phase_int_v(c_precision_int-1)) )
            );
        add_nsub_p_int_v := 
            ( ( (c_eng_mode) AND (NOT data_y_int_v(c_precision_int-1)) ) OR
              ( (NOT c_eng_mode) AND (phase_int_v(c_precision_int-1)) )   
            );

        ctrl_int_v(0) := ctrl_inp(0) AND eng_rfd_async;
        IF (c_reg_inputs = 1) THEN ctrl_int_v(0) := ctrl_inp(0) AND eng_rfd_reg; END IF;
        eng_rfd_async <= '1';
        IF (c_architecture = CORDIC_BEH_wser_arch) THEN
          eng_rfd_async <= (eng_rfd_reg AND NOT(eng_nd_reg)) OR eng_rdy;
        END IF;
                        
        FOR I IN 0 TO c_iterations_int-1 LOOP
          I_int_v := CORDIC_BEH_get_current_iteration(I,c_transform_type);
          data_x_hw_shift_v := CORDIC_BEH_rshift_slv(data_x_int_v,I_int_v+1);
          data_y_hw_shift_v := CORDIC_BEH_rshift_slv(data_y_int_v,I_int_v+1);
          IF (add_nsub_x_int_v = '1') THEN
            data_x_int_v := data_x_int_v(c_precision_int - 1 DOWNTO 0) + data_y_hw_shift_v(c_precision_int-1 DOWNTO 0);
          ELSE
            data_x_int_v := data_x_int_v(c_precision_int - 1 DOWNTO 0) - data_y_hw_shift_v(c_precision_int-1 DOWNTO 0);
          END IF;
          IF (add_nsub_y_int_v = '1') THEN
            data_y_int_v := data_y_int_v(c_precision_int - 1 DOWNTO 0) + data_x_hw_shift_v(c_precision_int-1 DOWNTO 0);
          ELSE
            data_y_int_v := data_y_int_v(c_precision_int - 1 DOWNTO 0) - data_x_hw_shift_v(c_precision_int-1 DOWNTO 0);  	
          END IF;
          IF (add_nsub_p_int_v = '1') THEN
            phase_int_v  := phase_int_v + eng_rom_vect(I_int_v);
          ELSE
            phase_int_v  := phase_int_v - eng_rom_vect(I_int_v);
          END IF;
        add_nsub_x_int_v := 
          ( ( ( ( (c_eng_mode) AND (data_y_int_v(c_precision_int-1)) ) OR
                ( (NOT c_eng_mode) AND (NOT phase_int_v(c_precision_int-1)) )
              ) AND transform_type_v ) OR
            ( ( ( (c_eng_mode) AND (NOT data_y_int_v(c_precision_int-1)) ) OR
                ( (NOT c_eng_mode) AND (phase_int_v(c_precision_int-1)) )   
              ) AND (NOT transform_type_v) )
          );
        add_nsub_y_int_v := 
            ( ( (c_eng_mode) AND (data_y_int_v(c_precision_int-1)) ) OR
              ( (NOT c_eng_mode) AND (NOT phase_int_v(c_precision_int-1)) )
            );
        add_nsub_p_int_v := 
            ( ( (c_eng_mode) AND (NOT data_y_int_v(c_precision_int-1)) ) OR
              ( (NOT c_eng_mode) AND (phase_int_v(c_precision_int-1)) )   
            );
        END LOOP;
        eng_data_x_async <= data_x_int_v;
        eng_data_y_async <= data_y_int_v;
        eng_phase_async  <= phase_int_v;
        eng_ctrl_async   <= ctrl_int_v;
      END PROCESS;
    
      inst_eng_delay : PROCESS(eng_data_x_async,eng_data_y_async,eng_phase_async,eng_ctrl_async, clk, aclr_int)
        CONSTANT c_eng_latency : INTEGER := CORDIC_BEH_max_int(c_eng_data_latency,c_eng_nd_latency);
        TYPE data_int_type IS ARRAY(c_eng_latency DOWNTO 0) OF STD_LOGIC_VECTOR(c_precision_int-1 DOWNTO 0);
        TYPE ctrl_int_type IS ARRAY(c_eng_latency DOWNTO 0) OF STD_LOGIC_VECTOR(c_ctrl_width-1 DOWNTO 0);
        VARIABLE data_x_int_v : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE data_y_int_v : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE phase_int_v  : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE ctrl_int_v   : ctrl_int_type := (OTHERS => (OTHERS => '0')); 
      BEGIN
        data_x_int_v(0) := eng_data_x_async;
        data_y_int_v(0) := eng_data_y_async;
        phase_int_v(0)  := eng_phase_async;
        ctrl_int_v(0)   := eng_ctrl_async;
        IF (aclr_int = '1') THEN
          FOR I IN c_eng_latency DOWNTO 1 LOOP
            data_x_int_v(I) := (OTHERS => '0');
            data_y_int_v(I) := (OTHERS => '0');
            phase_int_v(I)  := (OTHERS => '0');
            ctrl_int_v(I)   := (OTHERS => '0');
          END LOOP;
        ELSIF (clk'event AND clk = '1') THEN
          IF (ce_int = '1') THEN
            FOR I IN c_eng_latency DOWNTO 1 LOOP
              data_x_int_v(I) := data_x_int_v(I-1);
              data_y_int_v(I) := data_y_int_v(I-1);
              phase_int_v(I)  := phase_int_v(I-1);
              ctrl_int_v(I)   := ctrl_int_v(I-1);
            END LOOP;
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (ce_int = '1')) ) THEN
            FOR I IN c_eng_latency DOWNTO 1 LOOP
              data_x_int_v(I) := (OTHERS => '0');
              data_y_int_v(I) := (OTHERS => '0');
              phase_int_v(I)  := (OTHERS => '0');
              ctrl_int_v(I)   := (OTHERS => '0');
            END LOOP;
          END IF;      
        END IF;
        eng_data_x_fifo <= data_x_int_v(c_eng_data_latency) AFTER behav_reg_delay;
        eng_data_y_fifo <= data_y_int_v(c_eng_data_latency) AFTER behav_reg_delay;
        eng_phase_fifo <= phase_int_v(c_eng_data_latency) AFTER behav_reg_delay;
        eng_ctrl_fifo(0) <= ctrl_int_v(c_eng_nd_latency)(0) AFTER behav_reg_delay;
        IF (c_ctrl_width > 1) THEN
          eng_ctrl_fifo(c_ctrl_width-1 DOWNTO 1) <= ctrl_int_v(c_eng_data_latency)(c_ctrl_width-1 DOWNTO 1) AFTER behav_reg_delay;
        END IF;
        eng_rdy <= ctrl_int_v(c_eng_nd_latency)(0) AFTER behav_reg_delay;

      END PROCESS;--inst_eng_delay
    
        --Instantiate Registers
      inst_reg : PROCESS(clk, aclr_int)
        VARIABLE nd_v : STD_LOGIC := '0';
        VARIABLE rfd_v : STD_LOGIC := '1';
      BEGIN
        IF (aclr_int = '1') THEN
          nd_v := '0';
          rfd_v := '1';
        ELSIF (clk'event AND clk = '1') THEN
          IF (ce_int = '1') THEN
            nd_v := nd_int;
            rfd_v := eng_rfd_async;
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
          OR ((sclr_int = '1') AND (ce_int = '1')) ) THEN
            nd_v := '0';
            rfd_v := '1';
          END IF;      
        END IF;
        eng_nd_reg <= nd_v AFTER behav_reg_delay;
        eng_rfd_reg <= rfd_v AFTER behav_reg_delay;
      END PROCESS;--inst_data_reg

      data_x_eng <= eng_data_x_fifo;
      data_y_eng <= eng_data_y_fifo;
      phase_eng  <= eng_phase_fifo;
      ctrl_eng   <= eng_ctrl_fifo;
      rfd_eng    <= eng_rfd_async;
                
      -- If coarse rotate is turned off.
      gocr0: IF (c_coarse_rotate = 0) GENERATE
        outp_data_x_cr <= data_x_eng;
        outp_data_y_cr <= data_y_eng;
        outp_phase_cr <= phase_eng;
      END GENERATE;

      -- If Coarse Rotate is on Implement Coarse Rotation  
      gocr1: IF (c_coarse_rotate = 1) GENERATE

        outp_cr_quad(1) <= ctrl_eng(2);
        outp_cr_quad(0) <= ctrl_eng(1);

        -- Implement reverse rotation for a Rotate CORDIC Core
        gen_rotate_mode: IF (c_eng_mode = CORDIC_BEH_em_rotational) GENERATE

          rot_inv_coarse_rotate: PROCESS(outp_cr_quad,data_x_eng,data_y_eng)
          BEGIN
            CASE outp_cr_quad IS
        	    WHEN "11" => 
                outp_data_x_cr <= data_x_eng;
                outp_data_y_cr <= data_y_eng;
        	    WHEN "10" => 
                outp_data_x_cr <= data_y_eng;
                outp_data_y_cr <= - data_x_eng;
        	    WHEN "00" => 
                outp_data_x_cr <= - data_x_eng;
                outp_data_y_cr <= - data_y_eng;
        	    WHEN "01" => 
                outp_data_x_cr <= - data_y_eng;
                outp_data_y_cr <= data_x_eng;
              WHEN OTHERS =>
                outp_data_x_cr <= (OTHERS=> 'X');
                outp_data_y_cr <= (OTHERS=> 'X');
            END CASE;
          END PROCESS;--rot_inv_coarse_rotate
          outp_phase_cr <= phase_eng;
        END GENERATE;--gen_rotate_mode
    
        -- Implement reverse rotation for a Translate CORDIC Core
        gen_translate_mode: IF (c_eng_mode = CORDIC_BEH_em_translation) GENERATE

          outp_data_x_cr <= data_x_eng;
          outp_data_y_cr <= data_y_eng;
          trans_inv_coarse_rotate: PROCESS(outp_cr_quad,phase_eng)
          BEGIN
            CASE outp_cr_quad IS
              WHEN "11" => 
                outp_phase_cr <= phase_eng;
              WHEN "10" => 
                outp_phase_cr <= phase_eng + c_neg_pi_2_4_const ;
              WHEN "00" => 
                IF (phase_eng(c_precision_int-1) = '0') THEN
                  outp_phase_cr <= phase_eng + c_neg_pi_const ;
                ELSE	
                  outp_phase_cr <= phase_eng - c_neg_pi_const ;
                END IF;
              WHEN "01" => 
                outp_phase_cr <= phase_eng - c_neg_pi_2_4_const ;
              WHEN OTHERS =>
                outp_phase_cr <= (OTHERS=> 'X');
            END CASE;
          END PROCESS;--trans_inv_coarse_rotate
        END GENERATE;--gen_translate_mode

      END GENERATE;-- if Coarse Rotate = 1
  
      gsc0 : IF (c_scale_comp_int = CORDIC_BEH_scale_none) GENERATE

        gdx : IF (c_has_x_out = 1) GENERATE
          outp_data_x_sca <= outp_data_x_cr;
        END GENERATE;
        gdy : IF (c_has_y_out = 1) GENERATE
          outp_data_y_sca <= outp_data_y_cr;
        END GENERATE;
        gdp : IF (c_has_phase_out = 1) GENERATE
          outp_phase_sca <= outp_phase_cr;
        END GENERATE;
      END GENERATE;

      gsc1: IF (c_scale_comp_int /= CORDIC_BEH_scale_none) GENERATE

        gdx : IF (c_has_x_out = 1) GENERATE
          outp_data_x_sca_ext <= outp_data_x_cr * c_inv_scale;
          outp_data_x_sca <= outp_data_x_sca_ext(2*c_precision_int-3 DOWNTO c_precision_int-2);
        END GENERATE; -- gen scale_x

        gdy : IF (c_has_y_out = 1) GENERATE
          outp_data_y_sca_ext <= outp_data_y_cr * c_inv_scale;
          outp_data_y_sca <= outp_data_y_sca_ext(2*c_precision_int-3 DOWNTO c_precision_int-2);
        END GENERATE; -- Gen Scale y

        outp_phase_sca <= outp_phase_cr;

      END GENERATE; -- Gen Scale CCM
    
      outp_data_x_rnd <= CORDIC_BEH_rnd_slv(outp_data_x_sca, c_round_mode, c_output_width);
      outp_data_y_rnd <= CORDIC_BEH_rnd_slv(outp_data_y_sca, c_round_mode, c_output_width);
      outp_phase_rnd <= CORDIC_BEH_rnd_slv(outp_phase_sca, c_round_mode, c_output_width);
      outp_rdy_rnd <= ctrl_eng(0);
        
      --Instantiate CORDIC Latency Fifo
      inst_outp_data_delay : PROCESS(outp_data_x_rnd,outp_data_y_rnd,outp_phase_rnd,outp_rdy_rnd, clk, aclr_int)
        CONSTANT c_outp_latency : INTEGER := CORDIC_BEH_max_int(c_outp_data_latency,c_outp_nd_latency);
        TYPE data_int_type IS ARRAY(c_outp_latency DOWNTO 0) OF STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0);
        VARIABLE data_x_int_v : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE data_y_int_v : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE phase_int_v : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE rdy_int_v : STD_LOGIC_VECTOR(c_outp_latency DOWNTO 0) := (OTHERS => '0'); 

        VARIABLE test_c_outp_latency : INTEGER; 
      BEGIN
        data_x_int_v(0) := outp_data_x_rnd;
        data_y_int_v(0) := outp_data_y_rnd;
        phase_int_v(0)  := outp_phase_rnd;
        rdy_int_v(0)    := outp_rdy_rnd;
        IF (aclr_int = '1') THEN
          FOR I IN c_outp_latency DOWNTO 1 LOOP
            data_x_int_v(I) := (OTHERS => '0');
            data_y_int_v(I) := (OTHERS => '0');
            phase_int_v(I)  := (OTHERS => '0');
            rdy_int_v(I)    := '0';
          END LOOP;
        ELSIF (clk'event AND clk = '1') THEN
          IF (ce_int = '1') THEN
            FOR I IN c_outp_latency DOWNTO 1 LOOP
              data_x_int_v(I) := data_x_int_v(I-1);
              data_y_int_v(I) := data_y_int_v(I-1);
              phase_int_v(I)  := phase_int_v(I-1);
              rdy_int_v(I)    := rdy_int_v(I-1);
            END LOOP;
          test_c_outp_latency := CORDIC_BEH_max_int(c_outp_data_latency,c_outp_nd_latency);

          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (ce_int = '1')) ) THEN
            FOR I IN c_outp_latency DOWNTO 1 LOOP
              data_x_int_v(I) := (OTHERS => '0');
              data_y_int_v(I) := (OTHERS => '0');
              phase_int_v(I)  := (OTHERS => '0');
              rdy_int_v(I)    := '0';
            END LOOP;
          END IF;      
        END IF;
        IF (c_outp_data_latency > 0) THEN
          outp_data_x_fifo <= data_x_int_v(c_outp_data_latency-1) AFTER behav_reg_delay;
          outp_data_y_fifo <= data_y_int_v(c_outp_data_latency-1) AFTER behav_reg_delay;
          outp_phase_fifo <= phase_int_v(c_outp_data_latency-1) AFTER behav_reg_delay;
        ELSE
          outp_data_x_fifo <= data_x_int_v(0);
          outp_data_y_fifo <= data_y_int_v(0);
          outp_phase_fifo <= phase_int_v(0);
        END IF;
        IF(c_outp_nd_latency > 0) THEN
          outp_rdy_fifo <= rdy_int_v(c_outp_nd_latency-1) AFTER behav_reg_delay;
        ELSE
          outp_rdy_fifo <= rdy_int_v(0);
        END IF;
      END PROCESS;--inst_data_delay
      
      --Instantiate Output Register
      inst_data_reg : PROCESS(clk, aclr_int)
        VARIABLE data_x_int_v : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0'); 
        VARIABLE data_y_int_v : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
        VARIABLE phase_int_v  : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS => '0');
        VARIABLE rdy_int_v    : STD_LOGIC := '0'; 
      BEGIN
        IF (aclr_int = '1') THEN
          data_x_int_v := (OTHERS => '0');
          data_y_int_v := (OTHERS => '0');
          phase_int_v  := (OTHERS => '0');
          rdy_int_v    := '0';
        ELSIF (clk'event AND clk = '1') THEN
          IF (outp_ce_and_rdy = '1') THEN
            data_x_int_v := outp_data_x_fifo;
            data_y_int_v := outp_data_y_fifo;
            phase_int_v  := outp_phase_fifo;
          END IF;
          IF (ce_int = '1') THEN
            rdy_int_v := outp_rdy_fifo;
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (outp_ce_and_rdy = '1')) ) THEN
            data_x_int_v := (OTHERS => '0');
            data_y_int_v := (OTHERS => '0');
            phase_int_v  := (OTHERS => '0');
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (ce_int = '1')) ) THEN
            rdy_int_v    := '0';
          END IF;      
        END IF;

        outp_data_x_reg <= data_x_int_v AFTER behav_reg_delay;
        outp_data_y_reg <= data_y_int_v AFTER behav_reg_delay;
        outp_phase_reg  <= phase_int_v AFTER behav_reg_delay;
        outp_rdy_reg    <= rdy_int_v AFTER behav_reg_delay;

      END PROCESS;--inst_data_reg

      --Select Output Signals
      data_x_outp <= CORDIC_BEH_set_vect_slv(data_x_outp, 'Z') WHEN (c_has_x_out = 0) ELSE
                     outp_data_x_reg WHEN (c_outp_data_latency > 0) ELSE outp_data_x_fifo;
      data_y_outp <= CORDIC_BEH_set_vect_slv(data_y_outp, 'Z') WHEN (c_has_y_out = 0) ELSE
                     outp_data_y_reg WHEN (c_outp_data_latency > 0) ELSE outp_data_y_fifo;
      phase_outp <= CORDIC_BEH_set_vect_slv(phase_outp, 'Z') WHEN (c_has_phase_out = 0) ELSE
                     outp_phase_reg WHEN (c_outp_data_latency > 0) ELSE outp_phase_fifo;
      rdy_outp <= 'Z' WHEN (c_has_rdy = 0) ELSE
                     outp_rdy_reg WHEN (c_outp_data_latency > 0) ELSE outp_rdy_fifo;
      outp_ce_and_rdy <= (outp_rdy_fifo AND ce_int) OR (sclr_int AND ce_int);
      rfd_outp <= rfd_eng;
  
    END GENERATE;--Instantiate CORDIC core (Non Sqrt)

    --Instantiate SQRT Simplification to CORDIC core
    gisq: IF (c_cordic_function = CORDIC_BEH_f_sqrt) GENERATE

      gen_sqrt : PROCESS(data_x_init)
      BEGIN
        sqrt_data_trunc_async <= sqrt_slv(x_in, c_precision_int, c_data_format);
      END PROCESS;
      
      gen_sqrt_ext : PROCESS(sqrt_data_trunc_async)
      BEGIN
        sqrt_data_trunc_async_ext <= (OTHERS =>'0');
        sqrt_data_trunc_async_ext(c_precision_int-1 DOWNTO 0) <= sqrt_data_trunc_async;
      END PROCESS;

      gen_sqrt_round : PROCESS(sqrt_data_trunc_async_ext)
      BEGIN
        sqrt_data_round_async <= CORDIC_BEH_rnd_slv(sqrt_data_trunc_async_ext, c_rnd_mode_int, c_output_width);
      END PROCESS;
      
      --Instantiate Sqrt Latency Fifo to delay by c_sqrt_data_latency
      inst_data_delay : PROCESS(clk,aclr_int,sqrt_data_round_async,nd_int)
        TYPE data_int_type IS ARRAY(c_sqrt_data_latency DOWNTO 0) OF STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0);
        VARIABLE sqrt_data_v : data_int_type := (OTHERS => (OTHERS => '0')); 
        VARIABLE nd_v : STD_LOGIC_VECTOR(c_sqrt_data_latency DOWNTO 0) := (OTHERS => '0'); 
      BEGIN
        sqrt_data_v(0) := sqrt_data_round_async;
        nd_v(0) := nd_int; 
        IF (aclr_int = '1') THEN
          FOR I IN c_sqrt_data_latency DOWNTO 1 LOOP
            sqrt_data_v(I) := (OTHERS => '0');
            nd_v(I) := '0'; 
          END LOOP;
        ELSIF (clk'event AND clk = '1') THEN
          IF (ce_int = '1') THEN
            FOR I IN c_sqrt_data_latency DOWNTO 1 LOOP
              sqrt_data_v(I) := sqrt_data_v(I-1);
              nd_v(I) := nd_v(I-1); 
            END LOOP;
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (ce_int = '1')) ) THEN
            FOR I IN c_sqrt_data_latency DOWNTO 1 LOOP
              sqrt_data_v(I) := (OTHERS => '0');
              nd_v(I) := '0'; 
            END LOOP;
          END IF;      
        END IF;
        sqrt_data_fifo <= sqrt_data_v(c_sqrt_data_latency) AFTER behav_reg_delay;
        sqrt_nd_fifo <= nd_v(c_sqrt_data_latency) AFTER behav_reg_delay;
      END PROCESS;--inst_data_delay

      sqrt_rdy_int <= sqrt_nd_fifo;
      sqrt_ce_and_rdy <= ce_int AND sqrt_rdy_int;
  
      --Instantiate Output Registers
      inst_reg : PROCESS(clk, aclr_int)
        VARIABLE rdy_v : STD_LOGIC := '0';
        VARIABLE sqrt_v : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS=>'0'); 
      BEGIN
        IF (aclr_int = '1') THEN
          rdy_v := '0';
          sqrt_v := (OTHERS=>'0');
        ELSIF (clk'event AND clk = '1') THEN
          IF (ce_int = '1') THEN
            rdy_v := sqrt_rdy_int;
          END IF;
          IF (sqrt_ce_and_rdy = '1') THEN
            sqrt_v := sqrt_data_fifo;
          END IF;
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (ce_int = '1')) ) THEN
            rdy_v := '0';
          END IF;      
          IF ( ((c_sync_enable = c_override) AND (sclr_int = '1')) 
            OR ((sclr_int = '1') AND (sqrt_ce_and_rdy = '1')) ) THEN
            sqrt_v := (OTHERS=>'0');
          END IF;
        END IF;
        sqrt_rdy_reg <= rdy_v AFTER behav_reg_delay;
        sqrt_data_reg <= sqrt_v AFTER behav_reg_delay;
      END PROCESS;--inst_data_reg
  
      --Select between asynchronus and registered outputs.
      gen_tmp_sigs : PROCESS(sqrt_rdy_reg, sqrt_rdy_int, sqrt_data_reg, sqrt_data_fifo)
        VARIABLE rdy_v : STD_LOGIC := '0';
        VARIABLE sqrt_v : STD_LOGIC_VECTOR(c_output_width-1 DOWNTO 0) := (OTHERS=>'0'); 
      BEGIN
        rdy_v  := sqrt_rdy_reg;
        sqrt_v := sqrt_data_reg;
        IF (c_pipeline_mode=0 AND c_reg_outputs=0 AND c_reg_inputs=0) THEN
          rdy_v  := sqrt_rdy_int;
          sqrt_v := sqrt_data_fifo;
        END IF;
        rdy_sqrt  <= rdy_v;
        data_x_sqrt <= sqrt_v;
      END PROCESS;--inst_data_reg

    END GENERATE;
 
    g_no_buf0:IF(c_has_x_out = 1 ) GENERATE
      x_out <= data_x_sqrt WHEN (c_cordic_function = CORDIC_BEH_f_sqrt) ELSE data_x_outp;
    END GENERATE;
    -- y out
    g_no_buf1:IF(c_has_y_out = 1 ) GENERATE
      y_out <= (OTHERS=>'0') WHEN (c_cordic_function = CORDIC_BEH_f_sqrt) ELSE data_y_outp;
    END GENERATE;
    -- phase_out
    g_no_buf2:IF(c_has_phase_out = 1 ) GENERATE
      phase_out <= (OTHERS=>'0') WHEN (c_cordic_function = CORDIC_BEH_f_sqrt) ELSE phase_outp;
    END GENERATE;
    -- rfd out
    rfd_out: IF(c_has_rfd = 1) GENERATE
      rfd <= '1' WHEN (c_cordic_function = CORDIC_BEH_f_sqrt) ELSE rfd_outp;
    END GENERATE;
    -- ready out
    out_rdy: IF(c_has_rdy = 1 ) GENERATE
      rdy <= rdy_sqrt WHEN (c_cordic_function = CORDIC_BEH_f_sqrt) ELSE rdy_outp;
    END GENERATE;

  END behavioral;
